/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import de.adorsys.sts.keymanagement.KeyManagementConfigurationProperties;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyManagementService;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import de.adorsys.sts.keymanagement.service.KeyStoreInitializer;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import java.time.Clock;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"de.adorsys.sts.keymanagement"})
public class KeyManagementConfiguration {
    @Bean
    KeyConversionService keyConversionService(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyConversionService(keyManagementProperties.getKeystore().getPassword());
    }

    @Bean
    KeyManagementService keyManagerService(KeyStoreRepository keyStoreRepository, KeyConversionService keyConversionService) {
        return new KeyManagementService(keyStoreRepository, keyConversionService);
    }

    @Bean
    Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    KeyStoreGenerator keyStoreGenerator(Clock clock, @Qualifier(value="enc") KeyPairGenerator encKeyPairGenerator, @Qualifier(value="sign") KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyStoreGenerator(clock, encKeyPairGenerator, signKeyPairGenerator, secretKeyGenerator, (KeyManagementProperties)keyManagementProperties);
    }

    @Bean(name={"enc"})
    KeyPairGenerator encKeyPairGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGenerator(keyManagementProperties.getKeystore().getKeys().getEncKeyPairs());
    }

    @Bean(name={"sign"})
    KeyPairGenerator signKeyPairGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGenerator(keyManagementProperties.getKeystore().getKeys().getSignKeyPairs());
    }

    @Bean
    SecretKeyGenerator secretKeyGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new SecretKeyGenerator(keyManagementProperties.getKeystore().getKeys().getSecretKeys());
    }

    @Bean
    KeyStoreInitializer keyStoreInitializer(KeyStoreRepository keyStoreRepository, KeyStoreGenerator keyStoreGenerator) {
        return new KeyStoreInitializer(keyStoreRepository, keyStoreGenerator);
    }
}

