/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyRotationService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KeyRotationSchedule {
    private static final Logger LOG = LoggerFactory.getLogger(KeyRotationSchedule.class);
    private final KeyRotationService keyRotationService;
    private final KeyStoreRepository keyStoreRepository;
    private boolean isEnabled = false;

    @Autowired
    public KeyRotationSchedule(KeyRotationService keyRotationService, KeyStoreRepository keyStoreRepository) {
        this.keyRotationService = keyRotationService;
        this.keyStoreRepository = keyStoreRepository;
    }

    @Scheduled(initialDelayString="${sts.keymanagement.keystore.rotationCheckInterval}", fixedDelayString="${sts.keymanagement.keystore.rotationCheckInterval}")
    public void schedule() {
        if (this.isEnabled) {
            this.performEncryptionKeyPairRotation();
        }
    }

    private void performEncryptionKeyPairRotation() {
        LOG.debug("Perform key rotation...");
        StsKeyStore keyStore = this.keyStoreRepository.load();
        KeyRotationService.KeyRotationResult keyRotationResult = this.keyRotationService.rotate(keyStore);
        if (LOG.isDebugEnabled()) {
            List removedKeys = keyRotationResult.getRemovedKeys();
            LOG.debug(removedKeys.size() + " keys removed: [" + removedKeys.stream().collect(Collectors.joining(",")) + "]");
            List generatedKeys = keyRotationResult.getGeneratedKeys();
            LOG.debug(generatedKeys.size() + " keys generated: [" + generatedKeys.stream().collect(Collectors.joining(",")) + "]");
        }
        this.keyStoreRepository.save(keyStore);
        LOG.debug("Key rotation finished.");
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

