/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import de.adorsys.sts.keymanagement.EnableKeyManagement;
import de.adorsys.sts.keymanagement.KeyManagementConfigurationProperties;
import de.adorsys.sts.keymanagement.KeyRotationSchedule;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyManagementService;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.KeyRotationService;
import de.adorsys.sts.keymanagement.service.KeyStoreFilter;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import java.time.Clock;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@ComponentScan(value={"de.adorsys.sts.keymanagement"})
public class KeyManagerConfiguration
implements ImportAware {
    @Autowired
    private KeyRotationSchedule keyRotationSchedule;

    @Bean
    KeyConversionService keyConversionService(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyConversionService(keyManagementProperties.getKeystore().getPassword());
    }

    @Bean
    KeyRotationService keyRotationService(KeyStoreFilter keyStoreFilter, KeyStoreGenerator keyStoreGenerator, KeyManagementConfigurationProperties keyManagementProperties) {
        KeyManagementProperties.KeyStoreProperties.KeysProperties keysProperties = keyManagementProperties.getKeystore().getKeys();
        return new KeyRotationService(keyStoreFilter, keyStoreGenerator, keysProperties.getEncKeyPairs().getRotation(), keysProperties.getSignKeyPairs().getRotation(), keysProperties.getSecretKeys().getRotation());
    }

    @Bean
    KeyStoreFilter keyStoreFilter() {
        return new KeyStoreFilter(Clock.systemUTC());
    }

    @Bean
    KeyManagementService keyManagerService(KeyStoreRepository keyStoreRepository, KeyStoreGenerator keyStoreGenerator, KeyConversionService keyConversionService, KeyStoreFilter keyStoreFilter) {
        return new KeyManagementService(keyStoreRepository, keyStoreGenerator, keyConversionService, keyStoreFilter);
    }

    @Bean
    KeyStoreGenerator keyStoreGenerator(@Qualifier(value="enc") KeyPairGenerator encKeyPairGenerator, @Qualifier(value="sign") KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyStoreGenerator(encKeyPairGenerator, signKeyPairGenerator, secretKeyGenerator, (KeyManagementProperties)keyManagementProperties);
    }

    @Bean(name={"enc"})
    KeyPairGenerator encKeyPairGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGenerator(keyManagementProperties.getKeystore().getKeys().getEncKeyPairs());
    }

    @Bean(name={"sign"})
    KeyPairGenerator signKeyPairGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new KeyPairGenerator(keyManagementProperties.getKeystore().getKeys().getSignKeyPairs());
    }

    @Bean
    SecretKeyGenerator secretKeyGenerator(KeyManagementConfigurationProperties keyManagementProperties) {
        return new SecretKeyGenerator(keyManagementProperties.getKeystore().getKeys().getSecretKeys());
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configureKeyManagementByAnnotation(importMetadata);
    }

    private void configureKeyManagementByAnnotation(AnnotationMetadata importMetadata) {
        Map annotationAttributesMap = importMetadata.getAnnotationAttributes(EnableKeyManagement.class.getName());
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)annotationAttributesMap);
        boolean isKeyRotationEnabled = false;
        if (annotationAttributes != null) {
            isKeyRotationEnabled = annotationAttributes.getBoolean("keyRotationEnabled");
        }
        if (this.keyRotationSchedule != null) {
            this.keyRotationSchedule.setEnabled(isKeyRotationEnabled);
        }
    }
}

