/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement;

import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="sts.keymanagement")
@Validated
public class KeyManagementConfigurationProperties
implements KeyManagementProperties {
    @Valid
    private PersistenceConfigurationProperties persistence;
    @Valid
    @NotNull
    private KeyStoreConfigurationProperties keystore;

    public KeyManagementProperties.PersistenceProperties getPersistence() {
        return this.persistence;
    }

    public void setPersistence(PersistenceConfigurationProperties persistence) {
        this.persistence = persistence;
    }

    public KeyManagementProperties.KeyStoreProperties getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStoreConfigurationProperties keystore) {
        this.keystore = keystore;
    }

    @Validated
    public static class KeyStoreConfigurationProperties
    implements KeyManagementProperties.KeyStoreProperties {
        @NotNull
        @NotEmpty
        private String password;
        @NotNull
        @NotEmpty
        private String type;
        @NotNull
        @NotEmpty
        private String name;
        @NotNull
        @NotEmpty
        private String aliasPrefix;
        @Valid
        @NotNull
        private KeysConfigurationProperties keys;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAliasPrefix() {
            return this.aliasPrefix;
        }

        public void setAliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
        }

        public KeyManagementProperties.KeyStoreProperties.KeysProperties getKeys() {
            return this.keys;
        }

        public void setKeys(KeysConfigurationProperties keys) {
            this.keys = keys;
        }

        @Validated
        public static class KeysConfigurationProperties
        implements KeyManagementProperties.KeyStoreProperties.KeysProperties {
            @Valid
            @NotNull
            private KeyPairConfigurationProperties encKeyPairs;
            @Valid
            @NotNull
            private KeyPairConfigurationProperties signKeyPairs;
            @Valid
            @NotNull
            private SecretKeyConfigurationProperties secretKeys;

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties getEncKeyPairs() {
                return this.encKeyPairs;
            }

            public void setEncKeyPairs(KeyPairConfigurationProperties encKeyPairs) {
                this.encKeyPairs = encKeyPairs;
            }

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties getSignKeyPairs() {
                return this.signKeyPairs;
            }

            public void setSignKeyPairs(KeyPairConfigurationProperties signKeyPairs) {
                this.signKeyPairs = signKeyPairs;
            }

            public KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties getSecretKeys() {
                return this.secretKeys;
            }

            public void setSecretKeys(SecretKeyConfigurationProperties secretKeys) {
                this.secretKeys = secretKeys;
            }

            @Validated
            public static class KeyRotationConfigurationProperties
            implements KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties {
                @NotNull
                @Min(value=1L)
                private Long validityInterval;
                @NotNull
                @Min(value=1L)
                private Long legacyInterval;
                @NotNull
                @Min(value=1L)
                private Integer minKeys;
                private Boolean enabled = false;

                public Long getValidityInterval() {
                    return this.validityInterval;
                }

                public Long getLegacyInterval() {
                    return this.legacyInterval;
                }

                public Integer getMinKeys() {
                    return this.minKeys;
                }

                public Boolean isEnabled() {
                    return this.enabled;
                }

                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                public void setValidityInterval(Long validityInterval) {
                    this.validityInterval = validityInterval;
                }

                public void setLegacyInterval(Long legacyInterval) {
                    this.legacyInterval = legacyInterval;
                }

                public void setMinKeys(Integer minKeys) {
                    this.minKeys = minKeys;
                }
            }

            @Validated
            public static class SecretKeyConfigurationProperties
            implements KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties {
                @NotNull
                @Valid
                private KeyRotationConfigurationProperties rotation;
                private Integer initialCount = 1;
                @NotNull
                @NotEmpty
                private String algo;
                @NotNull
                private Integer size;

                public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties getRotation() {
                    return this.rotation;
                }

                public void setRotation(KeyRotationConfigurationProperties rotation) {
                    this.rotation = rotation;
                }

                public Integer getInitialCount() {
                    return this.initialCount;
                }

                public void setInitialCount(Integer initialCount) {
                    this.initialCount = initialCount;
                }

                public String getAlgo() {
                    return this.algo;
                }

                public void setAlgo(String algo) {
                    this.algo = algo;
                }

                public Integer getSize() {
                    return this.size;
                }

                public void setSize(Integer size) {
                    this.size = size;
                }
            }

            @Validated
            public static class KeyPairConfigurationProperties
            implements KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties {
                @NotNull
                @Valid
                private KeyRotationConfigurationProperties rotation;
                private Integer initialCount = 1;
                @NotNull
                @NotEmpty
                private String algo;
                @NotNull
                @NotEmpty
                private String sigAlgo;
                @NotNull
                private Integer size;
                @NotNull
                @NotEmpty
                private String name;

                public KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties getRotation() {
                    return this.rotation;
                }

                public void setRotation(KeyRotationConfigurationProperties rotation) {
                    this.rotation = rotation;
                }

                public Integer getInitialCount() {
                    return this.initialCount;
                }

                public void setInitialCount(Integer initialCount) {
                    this.initialCount = initialCount;
                }

                public String getAlgo() {
                    return this.algo;
                }

                public void setAlgo(String algo) {
                    this.algo = algo;
                }

                public String getSigAlgo() {
                    return this.sigAlgo;
                }

                public void setSigAlgo(String sigAlgo) {
                    this.sigAlgo = sigAlgo;
                }

                public Integer getSize() {
                    return this.size;
                }

                public void setSize(Integer size) {
                    this.size = size;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String name) {
                    this.name = name;
                }
            }
        }
    }

    @Validated
    public static class PersistenceConfigurationProperties
    implements KeyManagementProperties.PersistenceProperties {
        @NotNull
        @NotEmpty
        private String containerName;
        @NotNull
        @NotEmpty
        private String password;

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

