/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.service;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.tokenauth.BearerToken;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    static final String HEADER_STRING = "Authorization";

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader(HEADER_STRING);
        BearerToken bearerToken = new BearerToken(token);
        if (!bearerToken.isValid()) {
            return null;
        }
        JWTClaimsSet jwtClaimsSet = bearerToken.getClaims();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        List roles = bearerToken.extractRoles();
        if (roles != null) {
            for (String role : roles) {
                authorities.add(new SimpleGrantedAuthority(role));
            }
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)jwtClaimsSet.getSubject(), (Object)jwtClaimsSet, authorities);
        return authenticationToken;
    }
}

