/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.simpleencryption.keyprovider;

import com.nimbusds.jose.jwk.JWK;
import de.adorsys.sts.common.converter.KeyConverter;
import de.adorsys.sts.simpleencryption.KeyProvider;
import java.security.Key;
import java.text.ParseException;

class StaticRsaKeyProvider
implements KeyProvider {
    private final String key;

    StaticRsaKeyProvider(String key) {
        this.key = key;
    }

    @Override
    public Key getKeyForEncryption() {
        JWK parsedKey = this.tryToParseJwk(this.key);
        return KeyConverter.toPublic((JWK)parsedKey);
    }

    @Override
    public Key getKeyForDecryption(String keyId) {
        JWK parsedKey = this.tryToParseJwk(this.key);
        return KeyConverter.toPrivateOrSecret((JWK)parsedKey);
    }

    private JWK tryToParseJwk(String key) {
        JWK parsedKey;
        try {
            parsedKey = JWK.parse((String)key);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return parsedKey;
    }
}

