/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.simpleencryption.keyprovider;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import de.adorsys.sts.cryptoutils.JWEEncryptedSelector;
import de.adorsys.sts.simpleencryption.KeyProvider;
import de.adorsys.sts.simpleencryption.keyprovider.StaticAesKeyProvider;
import de.adorsys.sts.simpleencryption.keyprovider.StaticRsaKeyProvider;
import org.apache.commons.lang3.StringUtils;

public class StaticKeyProviderFactory {
    private StaticKeyProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static KeyProvider createKeyProvider(String jweAlgorithm, String jweEncryptionMethod, String key) {
        KeyProvider keyProvider;
        EncryptionMethod parsedEncryptionMethod;
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Encryption key must not be null or empty");
        }
        JWEAlgorithm parsedAlgorithm = JWEAlgorithm.parse((String)jweAlgorithm);
        if (JWEEncryptedSelector.isSupportedByAesCrypter((JWEAlgorithm)parsedAlgorithm, (EncryptionMethod)(parsedEncryptionMethod = EncryptionMethod.parse((String)jweEncryptionMethod)))) {
            keyProvider = new StaticAesKeyProvider(key);
        } else if (JWEEncryptedSelector.isSupportedByRsaCrypter((JWEAlgorithm)parsedAlgorithm, (EncryptionMethod)parsedEncryptionMethod)) {
            keyProvider = new StaticRsaKeyProvider(key);
        } else {
            throw new IllegalArgumentException("JWEAlgorithm " + jweAlgorithm + " or EncryptionMethod " + jweEncryptionMethod + " not supported");
        }
        return keyProvider;
    }
}

