/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.simpleencryption;

import de.adorsys.sts.cryptoutils.ObjectMapperSPI;
import de.adorsys.sts.simpleencryption.EncryptionException;
import de.adorsys.sts.simpleencryption.ObjectEncryption;
import de.adorsys.sts.simpleencryption.decrypt.Decrypter;
import de.adorsys.sts.simpleencryption.encrypt.Encrypter;
import java.io.IOException;
import java.util.Optional;

class JsonMappedObjectEncryption
implements ObjectEncryption {
    private final ObjectMapperSPI jsonMapper;
    private final Encrypter encrypter;
    private final Decrypter decrypter;

    JsonMappedObjectEncryption(ObjectMapperSPI jsonMapper, Encrypter encrypter, Decrypter decrypter) {
        this.jsonMapper = jsonMapper;
        this.encrypter = encrypter;
        this.decrypter = decrypter;
    }

    @Override
    public <T> T decrypt(String encrypted, Class<T> type) {
        String decryptedJson = this.decrypter.decrypt(encrypted);
        try {
            return (T)this.jsonMapper.readValue(decryptedJson, type);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public String decrypt(String encrypted) {
        return this.decrypter.decrypt(encrypted);
    }

    @Override
    public <T> Optional<T> tryToDecrypt(String encrypted, Class<T> type) {
        Optional<Object> decrypted = Optional.empty();
        Optional<String> maybeDecrypted = this.decrypter.tryToDecrypt(encrypted);
        if (maybeDecrypted.isPresent()) {
            try {
                Object t = this.jsonMapper.readValue(maybeDecrypted.get(), type);
                decrypted = Optional.of(t);
            }
            catch (IOException e) {
                decrypted = Optional.empty();
            }
        }
        return decrypted;
    }

    @Override
    public Optional<String> tryToDecrypt(String encrypted) {
        return this.decrypter.tryToDecrypt(encrypted);
    }

    @Override
    public String encrypt(Object object) throws EncryptionException {
        String json;
        try {
            json = this.jsonMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new EncryptionException(e);
        }
        return this.encrypter.encrypt(json);
    }

    @Override
    public String encrypt(String plainText) {
        return this.encrypter.encrypt(plainText);
    }
}

