/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.simpleencryption.encrypt;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import de.adorsys.sts.simpleencryption.EncryptionException;
import de.adorsys.sts.simpleencryption.KeyProvider;
import de.adorsys.sts.simpleencryption.encrypt.Encrypter;
import java.security.Key;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;

public class JweEncrypter
implements Encrypter {
    private final JWEEncrypter jweEncrypter;
    private final JWEHeader header;

    public JweEncrypter(KeyProvider keyProvider, JWEAlgorithm alg, EncryptionMethod enc) {
        this.jweEncrypter = JWEEncryptedSelector.getEncrypter((Key)keyProvider.getKeyForEncryption(), (JWEAlgorithm)alg, (EncryptionMethod)enc);
        this.header = new JWEHeader(alg, enc);
    }

    @Override
    public String encrypt(String plainText) {
        Payload payload = new Payload(plainText);
        JWEObject jweObject = new JWEObject(this.header, payload);
        try {
            jweObject.encrypt(this.jweEncrypter);
        }
        catch (JOSEException e) {
            throw new EncryptionException(e);
        }
        return jweObject.serialize();
    }
}

