/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.secretserver.configuration;

import de.adorsys.sts.filter.JWTAuthenticationFilter;
import de.adorsys.sts.secretserver.configuration.CorsProperties;
import de.adorsys.sts.token.authentication.TokenAuthenticationService;
import jakarta.servlet.Filter;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {
    private final CorsProperties corsProperties;

    public SecurityConfiguration(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }

    @Bean
    protected SecurityFilterChain securityFilterChain(HttpSecurity http, TokenAuthenticationService tokenAuthenticationService) throws Exception {
        if (this.corsProperties.isDisbaled()) {
            http.cors().disable();
        } else {
            http.cors().configurationSource(request -> {
                CorsConfiguration corsConfiguration = new CorsConfiguration();
                corsConfiguration.setAllowedOrigins(Arrays.asList(this.corsProperties.getAllowedOrigins()));
                corsConfiguration.setAllowedMethods(Arrays.asList(this.corsProperties.getAllowedMethods()));
                corsConfiguration.setAllowedHeaders(Arrays.asList(this.corsProperties.getAllowedHeaders()));
                return corsConfiguration;
            });
        }
        ((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/v2/api-docs", "/swagger-resources/**", "/swagger-ui.html", "/webjars/**"})).permitAll().requestMatchers(new String[]{"/v3/api-docs/**", "/swagger-ui/**", "/api/auth/**", "/api/test/**"})).permitAll().requestMatchers(new String[]{"/cloudfoundryapplication/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/pop"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/actuator/**"})).permitAll().anyRequest()).authenticated());
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(tokenAuthenticationService), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        Arrays.stream(this.corsProperties.getAllowedOrigins()).forEach(arg_0 -> ((CorsConfiguration)config).addAllowedOrigin(arg_0));
        Arrays.asList(this.corsProperties.getAllowedHeaders()).forEach(arg_0 -> ((CorsConfiguration)config).addAllowedHeader(arg_0));
        Arrays.stream(this.corsProperties.getAllowedMethods()).forEach(arg_0 -> ((CorsConfiguration)config).addAllowedMethod(arg_0));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

