/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.model;

import de.adorsys.sts.resourceserver.model.ResourceServer;
import org.apache.commons.lang3.StringUtils;

public class ResourceServerAndSecret {
    private ResourceServer resourceServer;
    private String rawSecret;
    private String encryptedSecret;

    public ResourceServer getResourceServer() {
        return this.resourceServer;
    }

    public String getRawSecret() {
        return this.rawSecret;
    }

    public void setRawSecret(String rawSecret) {
        this.rawSecret = rawSecret;
    }

    public String getEncryptedSecret() {
        return this.encryptedSecret;
    }

    public void setEncryptedSecret(String encryptedSecret) {
        this.encryptedSecret = encryptedSecret;
    }

    public boolean hasEncryptedSecret() {
        return StringUtils.isNotBlank((CharSequence)this.encryptedSecret);
    }

    ResourceServerAndSecret(ResourceServer resourceServer, String rawSecret, String encryptedSecret) {
        this.resourceServer = resourceServer;
        this.rawSecret = rawSecret;
        this.encryptedSecret = encryptedSecret;
    }

    public static ResourceServerAndSecretBuilder builder() {
        return new ResourceServerAndSecretBuilder();
    }

    public static class ResourceServerAndSecretBuilder {
        private ResourceServer resourceServer;
        private String rawSecret;
        private String encryptedSecret;

        ResourceServerAndSecretBuilder() {
        }

        public ResourceServerAndSecretBuilder resourceServer(ResourceServer resourceServer) {
            this.resourceServer = resourceServer;
            return this;
        }

        public ResourceServerAndSecretBuilder rawSecret(String rawSecret) {
            this.rawSecret = rawSecret;
            return this;
        }

        public ResourceServerAndSecretBuilder encryptedSecret(String encryptedSecret) {
            this.encryptedSecret = encryptedSecret;
            return this;
        }

        public ResourceServerAndSecret build() {
            return new ResourceServerAndSecret(this.resourceServer, this.rawSecret, this.encryptedSecret);
        }

        public String toString() {
            return "ResourceServerAndSecret.ResourceServerAndSecretBuilder(resourceServer=" + this.resourceServer + ", rawSecret=" + this.rawSecret + ", encryptedSecret=" + this.encryptedSecret + ")";
        }
    }
}

