/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.service.KeyRetrieverService;
import de.adorsys.sts.resourceserver.service.ResourceServerManagementProperties;
import de.adorsys.sts.resourceserver.service.ResourceServerService;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Optional;

public class RemoteKeyRetrieverService
implements KeyRetrieverService {
    private static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 250;
    private static final int DEFAULT_HTTP_READ_TIMEOUT = 250;
    private static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final ResourceRetriever resourceRetriever;
    private final ResourceServerService resourceServerService;

    public RemoteKeyRetrieverService(ResourceServerService resourceServerService, ResourceServerManagementProperties resourceServerManagementProperties) {
        this.resourceServerService = resourceServerService;
        ResourceServerManagementProperties.ResourceRetrieverProperties resourceRetrieverProperties = resourceServerManagementProperties.getResourceRetriever();
        this.resourceRetriever = new DefaultResourceRetriever(Optional.ofNullable(resourceRetrieverProperties.getHttpConnectTimeout()).orElse(250).intValue(), Optional.ofNullable(resourceRetrieverProperties.getHttpReadTimeout()).orElse(250).intValue(), Optional.ofNullable(resourceRetrieverProperties.getHttpSizeLimit()).orElse(51200).intValue());
    }

    @Override
    public JWKSet retrieve(String audience) {
        ResourceServer resourceServer = this.resourceServerService.getForAudience(audience);
        return this.retrieveJwkSet(resourceServer.getJwksUrl());
    }

    private JWKSet retrieveJwkSet(String endpointUrl) {
        Resource res;
        try {
            res = this.resourceRetriever.retrieveResource(new URL(endpointUrl));
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't retrieve remote jwk set from: " + endpointUrl, e);
        }
        try {
            JWKSet.parse((String)res.getContent());
            return JWKSet.parse((String)res.getContent());
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }
}

