/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;

public class ResourceServerInfo {
    public static final String jwks_url_key = "jwks_url";
    public static final String pop_key = "pop_url";
    private RemoteJWKSet<SecurityContext> jwkSource;
    private final ResourceRetriever resourceRetriever;
    private final ResourceServer resourceServer;

    public ResourceServerInfo(ResourceRetriever resourceRetriever, ResourceServer resourceServer) {
        if (resourceServer.getEndpointUrl() == null && resourceServer.getJwksUrl() == null) {
            throw new IllegalArgumentException("Either meta data URL or jwks_url must not be null");
        }
        if (resourceRetriever == null) {
            throw new IllegalArgumentException("The resourceRetriever must not be null");
        }
        this.resourceRetriever = resourceRetriever;
        this.resourceServer = resourceServer;
        if (resourceServer.getJwksUrl() != null) {
            try {
                this.jwkSource = new RemoteJWKSet(new URL(resourceServer.getJwksUrl()), resourceRetriever);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public RemoteJWKSet<SecurityContext> getJWKSource() {
        Map jsonObject;
        Resource res;
        if (this.jwkSource != null) {
            return this.jwkSource;
        }
        try {
            res = this.resourceRetriever.retrieveResource(new URL(this.resourceServer.getEndpointUrl()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't retrieve remote metadata: " + e.getMessage(), e);
        }
        try {
            jsonObject = JSONObjectUtils.parse((String)res.getContent());
        }
        catch (ParseException e) {
            throw new IllegalStateException("Couldn't parse remote metadata: " + e.getMessage(), e);
        }
        this.jwkSource = this.makeJwkSource(jsonObject, jwks_url_key);
        if (this.jwkSource != null) {
            return this.jwkSource;
        }
        this.jwkSource = this.makeJwkSource(jsonObject, pop_key);
        if (this.jwkSource != null) {
            return this.jwkSource;
        }
        try {
            JWKSet.parse((String)res.getContent());
            this.jwkSource = new RemoteJWKSet(new URL(this.resourceServer.getEndpointUrl()), this.resourceRetriever);
            return this.jwkSource;
        }
        catch (ParseException e) {
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException("No jwks url or pop_url provided for this server");
    }

    private RemoteJWKSet<SecurityContext> makeJwkSource(Map<String, Object> jsonObject, String key) {
        Object jwks_url = jsonObject.get(key);
        if (jwks_url != null) {
            try {
                return new RemoteJWKSet(new URL(jwks_url.toString()), this.resourceRetriever);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

