/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.persistence.ResourceServerRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FsPersistenceResourceServerRepository
implements ResourceServerRepository {
    private static final TypeReference<List<ResourceServer>> RESOURCE_SERVER_LIST_TYPE = new TypeReference<List<ResourceServer>>(){};
    private static final String RESOURCE_SERVER_CONTAINER = "RESOURCE_SERVER_CONTAINER";
    private static final String RESOURCE_SERVERS_FILE_NAME = "resource_servers";
    private final FsPersistenceFactory persFactory;
    private final ServerKeyManager keyManager;
    private String containerName;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public FsPersistenceResourceServerRepository(FsPersistenceFactory persFactory, ServerKeyManager keyManager) {
        this.persFactory = persFactory;
        this.keyManager = keyManager;
    }

    @PostConstruct
    public void postConstruct() {
        this.containerName = EnvProperties.getEnvOrSysProp((String)RESOURCE_SERVER_CONTAINER, (String)"sts-rservers");
        ContainerPersistence containerPersistence = this.persFactory.getContainerPersistence();
        if (!containerPersistence.containerExists(this.containerName)) {
            try {
                containerPersistence.creteContainer(this.containerName);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public List<ResourceServer> getAll() {
        return this.loadAll();
    }

    private List<ResourceServer> loadAll() {
        ArrayList resourceServers = Lists.newArrayList();
        ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
        byte[] resourceServersByte = null;
        try {
            resourceServersByte = this.persFactory.getServerObjectPersistence().loadObject(handle, this.keyManager);
        }
        catch (ObjectNotFoundException e) {
            return resourceServers;
        }
        catch (UnknownContainerException | WrongKeyCredentialException e) {
            throw new IllegalStateException(e);
        }
        try {
            return (List)this.objectMapper.readValue(resourceServersByte, RESOURCE_SERVER_LIST_TYPE);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void add(ResourceServer resourceServer) {
        if (!this.isValid(resourceServer)) {
            throw new RuntimeException("Resource server not valid");
        }
        List<ResourceServer> resourceServers = this.loadAll();
        this.add(resourceServer, resourceServers);
    }

    private Map<String, ResourceServer> mapResourceServers(List<ResourceServer> resourceServers) {
        return resourceServers.stream().collect(Collectors.toMap(ResourceServer::getAudience, Function.identity()));
    }

    private void add(ResourceServer resourceServer, List<ResourceServer> existingServers) {
        String audience;
        Map<String, ResourceServer> resourceServerMap = this.mapResourceServers(existingServers);
        if (resourceServerMap.containsKey(audience = resourceServer.getAudience())) {
            ResourceServer existingResourceServer = resourceServerMap.get(audience);
            if (!existingResourceServer.equals(resourceServer)) {
                int indexOf = existingServers.indexOf(existingResourceServer);
                existingServers.set(indexOf, resourceServer);
            }
        } else {
            existingServers.add(resourceServer);
        }
        this.persist(existingServers);
    }

    private void persist(List<ResourceServer> existingServers) {
        byte[] data;
        try {
            data = this.objectMapper.writeValueAsBytes(existingServers);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        ContentMetaInfo metaIno = null;
        ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
        EncryptionParams encParams = null;
        KeyAndJwk randomSecretKey = this.keyManager.getKeyMap().randomSecretKey();
        try {
            this.persFactory.getServerObjectPersistence().storeObject(data, metaIno, handle, this.keyManager, randomSecretKey.jwk.getKeyID(), encParams);
        }
        catch (UnknownContainerException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addAll(Iterable<ResourceServer> serversIn) {
        List<ResourceServer> existingServers = this.loadAll();
        if (Iterables.isEmpty(serversIn)) {
            return;
        }
        for (ResourceServer resourceServer : serversIn) {
            this.add(resourceServer, existingServers);
        }
    }

    private boolean isValid(ResourceServer resourceServer) {
        return !StringUtils.isBlank((CharSequence)resourceServer.getAudience());
    }
}

