/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import de.adorsys.sts.cryptoutils.JWEEncryptedSelector;
import de.adorsys.sts.resourceserver.exception.NoJwkFoundException;
import de.adorsys.sts.resourceserver.service.EncryptionService;
import de.adorsys.sts.resourceserver.service.KeyRetrieverService;
import de.adorsys.sts.resourceserver.service.SecretEncryptionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JweEncryptionService
implements EncryptionService {
    private static final JWKSelector encKeySelector = new JWKSelector(new JWKMatcher.Builder().keyUse(KeyUse.ENCRYPTION).build());
    private final KeyRetrieverService keyRetrieverService;

    public JweEncryptionService(KeyRetrieverService keyRetrieverService) {
        this.keyRetrieverService = keyRetrieverService;
    }

    @Override
    public String encryptFor(String audience, String secret) {
        JWKSet keySetForAudience = this.keyRetrieverService.retrieve(audience);
        JWK selectedKey = this.selectKeyFrom(keySetForAudience);
        return this.encrypt(selectedKey, secret);
    }

    @Override
    public Map<String, String> encryptFor(Iterable<String> audiences, String secret) {
        HashMap<String, String> encryptedSecrets = new HashMap<String, String>();
        for (String audience : audiences) {
            String encrypted = this.encryptFor(audience, secret);
            encryptedSecrets.put(audience, encrypted);
        }
        return encryptedSecrets;
    }

    private JWK selectKeyFrom(JWKSet keyset) throws NoJwkFoundException {
        List keys = encKeySelector.select(keyset);
        Collections.shuffle(keys);
        return (JWK)keys.stream().findAny().orElseThrow(() -> new NoJwkFoundException("Cannot find a JWK for encryption"));
    }

    @Override
    public String encrypt(JWK jwk, String rawSecret) throws SecretEncryptionException {
        JWEObject jweObj;
        JWEEncrypter jweEncrypter = JWEEncryptedSelector.getEncrypter((JWK)jwk, null, null);
        Payload payload = new Payload(rawSecret);
        try {
            jweObj = new JWEObject(this.getHeader(jwk), payload);
            jweObj.encrypt(jweEncrypter);
        }
        catch (JOSEException e) {
            throw new SecretEncryptionException(e);
        }
        return jweObj.serialize();
    }

    private JWEHeader getHeader(JWK jwk) throws JOSEException {
        JWEHeader header;
        if (jwk instanceof RSAKey) {
            header = new JWEHeader(JWEAlgorithm.RSA_OAEP, EncryptionMethod.A128GCM);
        } else if (jwk instanceof ECKey) {
            header = new JWEHeader(JWEAlgorithm.ECDH_ES_A128KW, EncryptionMethod.A192GCM);
        } else {
            return null;
        }
        return new JWEHeader.Builder(header).keyID(jwk.getKeyID()).build();
    }
}

