/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.sts.resourceserver.service.KeyRetrieverService;
import java.util.concurrent.TimeUnit;

public class CachingKeyRetrieverService
implements KeyRetrieverService {
    private final LoadingCache<String, JWKSet> jwkSets;

    public CachingKeyRetrieverService(final KeyRetrieverService keyRetrieverService, int maximumSize, int expireAfterAccessInMinutes) {
        this.jwkSets = CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterAccess((long)expireAfterAccessInMinutes, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, JWKSet>(){

            public JWKSet load(String audience) throws Exception {
                return keyRetrieverService.retrieve(audience);
            }
        });
    }

    @Override
    public JWKSet retrieve(String audience) {
        return (JWKSet)this.jwkSets.getUnchecked((Object)audience);
    }
}

