/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Describes a resource server", value="ResourceServer")
public class ResourceServer {
    @ApiModelProperty(value="The resource server's endpoint uri. This shall be the physical endpoint URL resource server.", required=true, example="http://localhost:8080/multibanking-service")
    private String endpointUrl;
    @ApiModelProperty(value="The user secret claim name. Value will be used to encrypt and decrypt proctected resources in the resource server's realm", required=false, example="userSecret")
    private String userSecretClaimName;
    @ApiModelProperty(value="States that the referenced resource server is an idp server. This exchange server will be accespt tokens produces by the resource server.", required=false, example="true", allowableValues="true,false")
    private boolean idpServer;
    @ApiModelProperty(value="The physical json web key set url of the resource server", required=false, example="http://localhost:8080/multibanking-service/pop")
    private String jwksUrl;
    @ApiModelProperty(value="The client id of the referenced resource server in the realm of this token exchange server", required=false, example="multibanking-service")
    private String clientId;
    @ApiModelProperty(value="The audience of this server in the realm of the exchange server. This is the audience field in the access token. This can also be an URI, but must not match the pysical address of the resource server", required=false, example="multibanking-service")
    private String audience;

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getUserSecretClaimName() {
        return this.userSecretClaimName;
    }

    public void setUserSecretClaimName(String userSecretClaimName) {
        this.userSecretClaimName = userSecretClaimName;
    }

    public boolean isIdpServer() {
        return this.idpServer;
    }

    public void setIdpServer(boolean idpServer) {
        this.idpServer = idpServer;
    }

    public String getJwksUrl() {
        return this.jwksUrl;
    }

    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.audience == null ? 0 : this.audience.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.endpointUrl == null ? 0 : this.endpointUrl.hashCode());
        result = 31 * result + (this.idpServer ? 1231 : 1237);
        result = 31 * result + (this.jwksUrl == null ? 0 : this.jwksUrl.hashCode());
        result = 31 * result + (this.userSecretClaimName == null ? 0 : this.userSecretClaimName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceServer other = (ResourceServer)obj;
        if (this.audience == null ? other.audience != null : !this.audience.equals(other.audience)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.endpointUrl == null ? other.endpointUrl != null : !this.endpointUrl.equals(other.endpointUrl)) {
            return false;
        }
        if (this.idpServer != other.idpServer) {
            return false;
        }
        if (this.jwksUrl == null ? other.jwksUrl != null : !this.jwksUrl.equals(other.jwksUrl)) {
            return false;
        }
        return !(this.userSecretClaimName == null ? other.userSecretClaimName != null : !this.userSecretClaimName.equals(other.userSecretClaimName));
    }
}

