/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.nimbusds.jose.jwk.JWK;
import de.adorsys.sts.resourceserver.service.EncryptionService;
import de.adorsys.sts.resourceserver.service.SecretEncryptionException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingEncryptionService
implements EncryptionService {
    private static final Logger logger = LoggerFactory.getLogger(LoggingEncryptionService.class);
    private final EncryptionService decoratedEncryptionService;

    public LoggingEncryptionService(EncryptionService encryptionService) {
        this.decoratedEncryptionService = encryptionService;
    }

    @Override
    public String encryptFor(String audience, String secret) {
        if (logger.isTraceEnabled()) {
            logger.trace("encryptFor audience started...");
        }
        String encryptedSecret = this.decoratedEncryptionService.encryptFor(audience, secret);
        if (logger.isTraceEnabled()) {
            logger.trace("encryptFor audience finished.");
        }
        return encryptedSecret;
    }

    @Override
    public Map<String, String> encryptFor(Iterable<String> audiences, String secret) {
        if (logger.isTraceEnabled()) {
            logger.trace("encryptFor audiences started...");
        }
        Map<String, String> encryptedSecrets = this.decoratedEncryptionService.encryptFor(audiences, secret);
        if (logger.isTraceEnabled()) {
            logger.trace("encryptFor audiences finished.");
        }
        return encryptedSecrets;
    }

    @Override
    public String encrypt(JWK jwk, String rawSecret) throws SecretEncryptionException {
        if (logger.isTraceEnabled()) {
            logger.trace("encrypt started...");
        }
        String encryptedSecret = this.decoratedEncryptionService.encrypt(jwk, rawSecret);
        if (logger.isTraceEnabled()) {
            logger.trace("encrypt finished.");
        }
        return encryptedSecret;
    }
}

