/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.processing;

import de.adorsys.sts.resourceserver.model.ResourceServerAndSecret;
import de.adorsys.sts.resourceserver.processing.ResourceServerProcessor;
import de.adorsys.sts.resourceserver.service.UserDataRepository;
import java.util.List;

public class ResourceServerProcessorService {
    private final ResourceServerProcessor resourceServerProcessor;
    private final UserDataRepository userDataRepository;

    public ResourceServerProcessorService(ResourceServerProcessor resourceServerProcessor, UserDataRepository userDataRepository) {
        this.resourceServerProcessor = resourceServerProcessor;
        this.userDataRepository = userDataRepository;
    }

    public List<ResourceServerAndSecret> processResources(String[] audiences, String[] resources, String username, String password) {
        this.createOrCheckAccess(username, password);
        return this.resourceServerProcessor.processResources(audiences, resources, this.userDataRepository, username, password);
    }

    public void storeCredentials(String username, String password, String audience, String userEncKey) {
        this.createOrCheckAccess(username, password);
        this.resourceServerProcessor.storeUserCredentials(this.userDataRepository, userEncKey, audience, username, password);
    }

    private void createOrCheckAccess(String username, String password) {
        this.userDataRepository.addAccount(username, password);
        this.userDataRepository.loadUserCredentials(username, password);
    }
}

