/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.provider;

import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.provider.ResourceServersProvider;
import java.util.ArrayList;
import java.util.List;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentVariableResourceServersProvider
implements ResourceServersProvider {
    @Override
    public List<ResourceServer> get() {
        String[] res_servers;
        ArrayList<ResourceServer> resourceServers = new ArrayList<ResourceServer>();
        String res_servers_prop = EnvProperties.getEnvOrSysProp((String)"RESOURCE_SERVER_NAMES", (String)"");
        for (String res_server_name : res_servers = StringUtils.split((String)res_servers_prop, (String)",")) {
            ResourceServer resourceServer = this.mapToResourceServer(res_server_name);
            resourceServers.add(resourceServer);
        }
        return resourceServers;
    }

    private ResourceServer mapToResourceServer(String res_server_name) {
        String res_server_endpoint_url = EnvProperties.getEnvOrSysProp((String)(res_server_name + "_ENDPOINT_URL"), (boolean)true);
        String res_server_jwks_url = EnvProperties.getEnvOrSysProp((String)(res_server_name + "_JWKS_URL"), (boolean)true);
        String res_server_client_id = EnvProperties.getEnvOrSysProp((String)(res_server_name + "_CLIENT_ID"), (boolean)true);
        String res_server_user_secret_claim = EnvProperties.getEnvOrSysProp((String)(res_server_name + "_USER_SECRET_CLAIM"), (boolean)true);
        String res_server_audience = EnvProperties.getEnvOrSysProp((String)(res_server_name + "_AUDIENCE_NAME"), (boolean)false);
        ResourceServer resourceServer = new ResourceServer();
        resourceServer.setAudience(res_server_audience);
        if (StringUtils.isNotBlank((CharSequence)res_server_endpoint_url)) {
            resourceServer.setEndpointUrl(res_server_endpoint_url);
        }
        if (StringUtils.isNotBlank((CharSequence)res_server_jwks_url)) {
            resourceServer.setJwksUrl(res_server_jwks_url);
        }
        if (StringUtils.isNotBlank((CharSequence)res_server_client_id)) {
            resourceServer.setClientId(res_server_client_id);
        }
        if (StringUtils.isNotBlank((CharSequence)res_server_user_secret_claim)) {
            resourceServer.setUserSecretClaimName(res_server_user_secret_claim);
        }
        resourceServer.setIdpServer(false);
        return resourceServer;
    }
}

