/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import de.adorsys.sts.resourceserver.model.UserCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.exceptions.KeystoreNotFoundException;
import org.adorsys.encobject.userdata.ObjectPersistenceAdapter;
import org.adorsys.encobject.userdata.UserDataNamingPolicy;

public class UserDataService {
    private UserDataNamingPolicy namingPolicy;
    private ObjectPersistenceAdapter objectPersistenceAdapter;

    public UserDataService(UserDataNamingPolicy namingPolicy, ObjectPersistenceAdapter objectPersistenceAdapter) {
        this.namingPolicy = namingPolicy;
        this.objectPersistenceAdapter = objectPersistenceAdapter;
    }

    public void addAccount() throws KeystoreNotFoundException {
        if (this.objectPersistenceAdapter.hasStore()) {
            throw new KeystoreNotFoundException("User " + this.objectPersistenceAdapter.getKeyCredentials().getKeyid() + " already have an account.");
        }
        this.objectPersistenceAdapter.initStore();
        UserCredentials userCredentials = new UserCredentials();
        userCredentials.setUsername(this.objectPersistenceAdapter.getKeyCredentials().getHandle().getContainer());
        this.storeUserCredentials(userCredentials);
    }

    public boolean hasAccount() {
        return this.objectPersistenceAdapter.hasStore();
    }

    public UserCredentials loadUserCredentials() {
        ObjectHandle handleForUserMainRecord = this.namingPolicy.handleForUserMainRecord(this.objectPersistenceAdapter.getKeyCredentials());
        return (UserCredentials)this.objectPersistenceAdapter.load(handleForUserMainRecord, UserCredentials.class);
    }

    public void storeUserCredentials(UserCredentials userCredentials) {
        ObjectHandle handleForUserMainRecord = this.namingPolicy.handleForUserMainRecord(this.objectPersistenceAdapter.getKeyCredentials());
        this.objectPersistenceAdapter.store(handleForUserMainRecord, (Object)userCredentials);
    }
}

