/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.processing;

import de.adorsys.sts.resourceserver.model.ResourceServerAndSecret;
import de.adorsys.sts.resourceserver.model.UserCredentials;
import de.adorsys.sts.resourceserver.processing.ResourceServerProcessor;
import de.adorsys.sts.resourceserver.service.UserDataService;
import java.util.List;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.service.EncObjectService;
import org.adorsys.encobject.service.KeystoreNotFoundException;
import org.adorsys.encobject.userdata.ObjectMapperSPI;
import org.adorsys.encobject.userdata.ObjectPersistenceAdapter;
import org.adorsys.encobject.userdata.UserDataNamingPolicy;

public class ResourceServerProcessorService {
    private final ResourceServerProcessor resourceServerProcessor;
    private final UserDataNamingPolicy namingPolicy;
    private final EncObjectService encObjectService;
    private final ObjectMapperSPI objectMapper;

    public ResourceServerProcessorService(ResourceServerProcessor resourceServerProcessor, UserDataNamingPolicy namingPolicy, EncObjectService encObjectService, ObjectMapperSPI objectMapper) {
        this.resourceServerProcessor = resourceServerProcessor;
        this.namingPolicy = namingPolicy;
        this.encObjectService = encObjectService;
        this.objectMapper = objectMapper;
    }

    public List<ResourceServerAndSecret> processResources(String[] audiences, String[] resources, String username, String password) {
        KeyCredentials keyCredentials = this.namingPolicy.newKeyCredntials(username, password);
        ObjectPersistenceAdapter persistenceAdapter = new ObjectPersistenceAdapter(this.encObjectService, keyCredentials, this.objectMapper);
        UserDataService userDataService = new UserDataService(this.namingPolicy, persistenceAdapter);
        if (!userDataService.hasAccount()) {
            try {
                userDataService.addAccount();
            }
            catch (KeystoreNotFoundException e) {
                throw new IllegalStateException();
            }
        }
        UserCredentials loadUserCredentials = userDataService.loadUserCredentials();
        return this.resourceServerProcessor.processResources(audiences, resources, userDataService);
    }

    public void storeCredentials(String login, String password, String audience, String userEncKey) {
        KeyCredentials keyCredentials = this.namingPolicy.newKeyCredntials(login, password);
        ObjectPersistenceAdapter persistenceAdapter = new ObjectPersistenceAdapter(this.encObjectService, keyCredentials, this.objectMapper);
        UserDataService userDataService = new UserDataService(this.namingPolicy, persistenceAdapter);
        if (!userDataService.hasAccount()) {
            try {
                userDataService.addAccount();
            }
            catch (KeystoreNotFoundException e) {
                throw new IllegalStateException();
            }
        }
        this.resourceServerProcessor.storeUserCredentials(userDataService, userEncKey, audience);
    }
}

