/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.service.ResourceServerService;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;

public class KeyRetrieverService {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 250;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final ResourceRetriever resourceRetriever = new DefaultResourceRetriever(250, 250, 51200);
    private final ResourceServerService resourceServerService;

    public KeyRetrieverService(ResourceServerService resourceServerService) {
        this.resourceServerService = resourceServerService;
    }

    public JWKSet retrieve(String audience) {
        ResourceServer resourceServer = this.resourceServerService.getForAudience(audience);
        return this.retrieveJwkSet(resourceServer.getJwksUrl());
    }

    private JWKSet retrieveJwkSet(String endpointUrl) {
        Resource res;
        try {
            res = this.resourceRetriever.retrieveResource(new URL(endpointUrl));
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't retrieve remote jwk set from: " + endpointUrl, e);
        }
        try {
            JWKSet.parse((String)res.getContent());
            return JWKSet.parse((String)res.getContent());
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }
}

