/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.model.ResourceServers;
import de.adorsys.sts.resourceserver.provider.ResourceServersProvider;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceServerService {
    private final ResourceServersProvider resourceServersProvider;
    private ResourceServers resourceServers;
    private Map<String, Map<String, ResourceServer>> mappedResourceServers;

    @Autowired
    public ResourceServerService(ResourceServersProvider resourceServersProvider) {
        this.resourceServersProvider = resourceServersProvider;
    }

    public ResourceServer getForClient(String clientId) {
        Map<String, Map<String, ResourceServer>> resourceServersMap = this.getMappedResourceServers();
        ResourceServer resourceServer = resourceServersMap.get("clientId").get(clientId);
        if (resourceServer == null) {
            throw new RuntimeException("No resource server found for client '" + clientId + "'");
        }
        return resourceServer;
    }

    private Map<String, Map<String, ResourceServer>> getMappedResourceServers() {
        if (this.mappedResourceServers == null) {
            ResourceServers resourceServers = this.getResourceServers();
            this.mappedResourceServers = resourceServers.toMultiMap();
        }
        return this.mappedResourceServers;
    }

    private ResourceServers getResourceServers() {
        if (this.resourceServers == null) {
            this.resourceServers = this.resourceServersProvider.get();
        }
        return this.resourceServers;
    }
}

