/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver.service;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import de.adorsys.sts.resourceserver.service.KeyRetrieverService;
import de.adorsys.sts.resourceserver.service.SecretEncryptionException;
import java.util.List;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;
import org.adorsys.jjwk.selector.KeyExtractionException;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EncryptionService {
    private static final JWKSelector encKeySelector = new JWKSelector(new JWKMatcher.Builder().keyUse(KeyUse.ENCRYPTION).build());
    private final KeyRetrieverService keyRetrieverService;

    @Autowired
    public EncryptionService(KeyRetrieverService keyRetrieverService) {
        this.keyRetrieverService = keyRetrieverService;
    }

    public String encryptFor(String clientId, String secret) {
        JWKSet keySetForClient = this.keyRetrieverService.retrieve(clientId);
        JWK selectedKey = this.selectKeyFrom(keySetForClient);
        return this.encrypt(selectedKey, secret);
    }

    private JWK selectKeyFrom(JWKSet keyset) {
        List keys = encKeySelector.select(keyset);
        return (JWK)keys.stream().findFirst().orElseThrow(RuntimeException::new);
    }

    public String encrypt(JWK jwk, String rawSecret) throws SecretEncryptionException {
        JWEObject jweObj;
        JWEEncrypter jweEncrypter;
        try {
            jweEncrypter = JWEEncryptedSelector.geEncrypter((JWK)jwk, null, null);
        }
        catch (KeyExtractionException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
            throw new SecretEncryptionException(e);
        }
        Payload payload = new Payload(rawSecret);
        try {
            jweObj = new JWEObject(this.getHeader(jwk), payload);
            jweObj.encrypt(jweEncrypter);
        }
        catch (JOSEException e) {
            throw new SecretEncryptionException(e);
        }
        return jweObj.serialize();
    }

    private JWEHeader getHeader(JWK jwk) throws JOSEException {
        JWEHeader header;
        if (jwk instanceof RSAKey) {
            header = new JWEHeader(JWEAlgorithm.RSA_OAEP, EncryptionMethod.A128GCM);
        } else if (jwk instanceof ECKey) {
            header = new JWEHeader(JWEAlgorithm.ECDH_ES_A128KW, EncryptionMethod.A192GCM);
        } else {
            return null;
        }
        return new JWEHeader.Builder(header).keyID(jwk.getKeyID()).build();
    }
}

