/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver;

import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.sts.resourceserver.model.ResourceServerAndSecret;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.adorsys.envutils.EnvProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;

public class ResponseUtils {
    public static final String ERROR_FIELD = "error";
    public static final String ERROR_DESCRIPTION_FIELD = "error_description";
    public static final String ERROR_INVALID_REQUEST_VALUE = "invalid_request";

    public static String getIssuer(HttpServletRequest servletRequest) {
        String issuerUrl = EnvProperties.getEnvOrSysProp((String)"AUTH_SERVER_ISS_URL", (boolean)true);
        if (StringUtils.isNotBlank((CharSequence)issuerUrl)) {
            return issuerUrl;
        }
        return StringUtils.substringBeforeLast((String)servletRequest.getRequestURL().toString(), (String)servletRequest.getRequestURI());
    }

    public static ResponseEntity<Object> missingParam(String paramName) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        resultMap.put(ERROR_FIELD, Collections.singletonList(ERROR_INVALID_REQUEST_VALUE));
        resultMap.put(ERROR_DESCRIPTION_FIELD, Collections.singletonList("Request parameter " + paramName + " is missing. See https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-08#section-2.1"));
        return ResponseEntity.badRequest().body((Object)CollectionUtils.toMultiValueMap(resultMap));
    }

    public static ResponseEntity<Object> invalidParam(String message) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        resultMap.put(ERROR_FIELD, Collections.singletonList(ERROR_INVALID_REQUEST_VALUE));
        resultMap.put(ERROR_DESCRIPTION_FIELD, Collections.singletonList(message));
        return ResponseEntity.badRequest().body((Object)CollectionUtils.toMultiValueMap(resultMap));
    }

    public static JWTClaimsSet.Builder handleResources(JWTClaimsSet.Builder claimSetBuilder, List<ResourceServerAndSecret> processedResources) {
        if (processedResources.isEmpty()) {
            return claimSetBuilder;
        }
        if (processedResources.size() == 1) {
            claimSetBuilder = claimSetBuilder.audience(processedResources.get(0).getResourceServer().getAudience());
        } else {
            ArrayList<String> processedResourcesStr = new ArrayList<String>();
            for (ResourceServerAndSecret resourceServerAndSecret : processedResources) {
                processedResourcesStr.add(resourceServerAndSecret.getResourceServer().getAudience());
            }
            claimSetBuilder = claimSetBuilder.audience(processedResourcesStr);
        }
        return claimSetBuilder;
    }
}

