/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.resourceserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.sts.resourceserver.ResourceServerError;
import de.adorsys.sts.resourceserver.ResourceServerErrors;
import de.adorsys.sts.resourceserver.ResourceServerException;
import de.adorsys.sts.resourceserver.model.ResourceServer;
import de.adorsys.sts.resourceserver.model.ResourceServers;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.filesystem.FsPersistenceFactory;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.envutils.EnvProperties;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceServerManager {
    private static final String RESOURCE_SERVER_CONTAINER = "RESOURCE_SERVER_CONTAINER";
    @Autowired
    private FsPersistenceFactory persFactory;
    private String containerName;
    private static final String RESOURCE_SERVERS_FILE_NAME = "resource_servers";
    @Autowired
    private ServerKeyManager keyManager;
    private ObjectMapper objectMapper = new ObjectMapper();
    private ResourceServers resourceServers;
    private Map<String, Map<String, ResourceServer>> resourceServersMultiMap;

    @PostConstruct
    public void postConstruct() {
        this.containerName = EnvProperties.getEnvOrSysProp((String)RESOURCE_SERVER_CONTAINER, (String)"sts-rservers");
        ContainerPersistence containerPersistence = this.persFactory.getContainerPersistence();
        if (!containerPersistence.containerExists(this.containerName)) {
            try {
                containerPersistence.creteContainer(this.containerName);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException(e);
            }
        }
        this.resourceServers = this.loadResourceServers();
        this.resourceServersMultiMap = this.resourceServers.toMultiMap();
    }

    public ResourceServers loadResourceServers() {
        ResourceServers resourceServers = new ResourceServers();
        ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
        byte[] resourceServersByte = null;
        try {
            resourceServersByte = this.persFactory.getServerObjectPersistence().loadObject(handle, this.keyManager);
        }
        catch (ObjectNotFoundException e) {
            return resourceServers;
        }
        catch (UnknownContainerException | WrongKeyCredentialException e) {
            throw new IllegalStateException(e);
        }
        try {
            resourceServers = (ResourceServers)this.objectMapper.readValue(resourceServersByte, ResourceServers.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return resourceServers;
    }

    public Map<String, Map<String, ResourceServer>> getResourceServersMultiMap() {
        return this.resourceServersMultiMap;
    }

    public ResourceServers addResourceServers(ResourceServers resourceServersIn) throws ResourceServerException {
        List<ResourceServer> serversIn = resourceServersIn.getServers();
        ResourceServers resourceServers = this.loadResourceServers();
        if (serversIn.isEmpty()) {
            return resourceServers;
        }
        ResourceServerErrors errors = new ResourceServerErrors();
        List<ResourceServer> serversList = resourceServers.getServers();
        for (ResourceServer resourceServer : serversIn) {
            if (StringUtils.isBlank((CharSequence)resourceServer.getAudience())) {
                ResourceServerError resourceServerError = new ResourceServerError("missing audience", resourceServer);
                errors.getErros().add(resourceServerError);
                continue;
            }
            ResourceServer serverToReplace = null;
            for (ResourceServer server : serversList) {
                if (resourceServer.equals(server) || !StringUtils.equals((CharSequence)resourceServer.getAudience(), (CharSequence)server.getAudience())) continue;
                serverToReplace = server;
                break;
            }
            if (serverToReplace == null) continue;
            int indexOf = serversList.indexOf(serverToReplace);
            serversList.set(indexOf, resourceServer);
        }
        if (!errors.getErros().isEmpty()) {
            throw new ResourceServerException(errors);
        }
        for (ResourceServer resourceServer : serversIn) {
            byte[] data;
            resourceServers.getServers().add(resourceServer);
            try {
                data = this.objectMapper.writeValueAsBytes((Object)resourceServers);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
            ContentMetaInfo metaIno = null;
            ObjectHandle handle = new ObjectHandle(this.containerName, RESOURCE_SERVERS_FILE_NAME);
            EncryptionParams encParams = null;
            KeyAndJwk randomSecretKey = this.keyManager.getKeyMap().randomSecretKey();
            try {
                this.persFactory.getServerObjectPersistence().storeObject(data, metaIno, handle, this.keyManager, randomSecretKey.jwk.getKeyID(), encParams);
            }
            catch (UnknownContainerException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
                throw new IllegalStateException(e);
            }
        }
        this.resourceServers = resourceServers;
        this.resourceServersMultiMap = resourceServers.toMultiMap();
        return resourceServers;
    }
}

