/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence.mongo;

import de.adorsys.sts.persistence.mongo.entity.SecretEntity;
import de.adorsys.sts.persistence.mongo.repository.MongoSecretRepository;
import de.adorsys.sts.secret.Secret;
import de.adorsys.sts.secret.SecretRepository;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MongoDatabaseSecretRepository
implements SecretRepository {
    private final MongoSecretRepository secretRepository;

    @Autowired
    public MongoDatabaseSecretRepository(MongoSecretRepository secretRepository) {
        this.secretRepository = secretRepository;
    }

    public Secret get(String subject) {
        return this.findSecretBySubject(subject);
    }

    public Optional<Secret> tryToGet(String subject) {
        return Optional.ofNullable(this.findSecretBySubject(subject));
    }

    public void save(String subject, Secret secret) {
        SecretEntity secretEntity = new SecretEntity();
        secretEntity.setSubject(subject);
        secretEntity.setValue(secret.getValue());
        this.secretRepository.save(secretEntity);
    }

    private Secret findSecretBySubject(String subject) {
        SecretEntity foundSecret = this.secretRepository.findBySubject(subject);
        if (foundSecret == null) {
            return null;
        }
        return new Secret(foundSecret.getValue());
    }
}

