/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence.mongo.config;

import com.mongodb.client.MongoClient;
import de.adorsys.sts.keymanagement.KeyManagementConfiguration;
import de.adorsys.sts.keymanagement.bouncycastle.BouncyCastleProviderConfiguration;
import de.adorsys.sts.lock.ExecutionLockConfiguration;
import de.adorsys.sts.persistence.mongo.repository.MongoKeyStoreRepository;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.mongo.MongoLockProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@ComponentScan(basePackages={"de.adorsys.sts.persistence.mongo"})
@Import(value={KeyManagementConfiguration.class, ExecutionLockConfiguration.class, BouncyCastleProviderConfiguration.class})
@EnableMongoRepositories(basePackageClasses={MongoKeyStoreRepository.class})
public class MongoConfiguration {
    @Bean
    LockProvider lockProvider(MongoClient client, @Value(value="${de.adorsys.sts.lock.collection:sts.sts_lock}") String lockTable) {
        String[] dbAndCollection = lockTable.split("\\.");
        return new MongoLockProvider(client.getDatabase(dbAndCollection[0]).getCollection(dbAndCollection[1]));
    }
}

