/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence.mongo.mapper;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.keystore.KeyStoreView;
import de.adorsys.keymanagement.api.types.entity.KeyEntry;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyEntry;
import de.adorsys.sts.keymanagement.model.PasswordCallbackHandler;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyEntryImpl;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.model.UnmodifyableKeystore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.persistence.mongo.entity.KeyEntryAttributesEntity;
import de.adorsys.sts.persistence.mongo.entity.KeyStoreEntity;
import java.security.KeyStore;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeyStoreEntityMapper {
    private static final ZonedDateTime DEFAULT_LAST_UPDATE = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    private final Juggler juggler;
    private final PasswordCallbackHandler keyPassHandler;
    private final String keystoreName;

    @Autowired
    public KeyStoreEntityMapper(Juggler juggler, KeyManagementProperties keyManagementProperties) {
        this.juggler = juggler;
        String keyStorePassword = keyManagementProperties.getKeystore().getPassword();
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
        this.keystoreName = keyManagementProperties.getKeystore().getName();
    }

    public KeyStoreEntity mapToEntity(StsKeyStore keyStore) {
        KeyStoreEntity persistentKeyStore = new KeyStoreEntity();
        this.mapIntoEntity(keyStore, persistentKeyStore);
        return persistentKeyStore;
    }

    public void mapIntoEntity(StsKeyStore keyStore, KeyStoreEntity persistentKeyStore) {
        UnmodifyableKeystore toPersist = keyStore.getKeyStoreCopy();
        byte[] bytes = toPersist.toBytes(this.juggler, () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
        persistentKeyStore.setName(this.keystoreName);
        persistentKeyStore.setKeystore(bytes);
        persistentKeyStore.setType(toPersist.getType());
        persistentKeyStore.setLastUpdate(this.convert(keyStore.getLastUpdate()));
        Map<String, KeyEntryAttributesEntity> mappedEntryAttributes = this.mapToEntityMap(keyStore.getEntries());
        persistentKeyStore.setEntries(mappedEntryAttributes);
    }

    private Map<String, KeyEntryAttributesEntity> mapToEntityMap(Map<String, StsKeyEntry> keyEntries) {
        return keyEntries.values().stream().map(this::mapToEntity).collect(Collectors.toMap(KeyEntryAttributesEntity::getAlias, Function.identity()));
    }

    private KeyEntryAttributesEntity mapToEntity(StsKeyEntry keyEntry) {
        KeyEntryAttributesEntity entryAttributes = new KeyEntryAttributesEntity();
        entryAttributes.setAlias(keyEntry.getAlias());
        entryAttributes.setCreatedAt(this.convert(keyEntry.getCreatedAt()));
        entryAttributes.setNotBefore(this.convert(keyEntry.getNotBefore()));
        entryAttributes.setNotAfter(this.convert(keyEntry.getNotAfter()));
        entryAttributes.setExpireAt(this.convert(keyEntry.getExpireAt()));
        entryAttributes.setValidityInterval(keyEntry.getValidityInterval());
        entryAttributes.setLegacyInterval(keyEntry.getLegacyInterval());
        entryAttributes.setState(keyEntry.getState());
        entryAttributes.setKeyUsage(keyEntry.getKeyUsage());
        return entryAttributes;
    }

    private Date convert(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return Date.from(zonedDateTime.toInstant());
    }

    private ZonedDateTime convert(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneOffset.UTC);
    }

    private Map<String, StsKeyEntry> mapFromEntities(Map<String, KeyEntryAttributesEntity> persistentKeyEntries) {
        HashMap<String, StsKeyEntry> mappedKeyEntries = new HashMap<String, StsKeyEntry>();
        for (Map.Entry<String, KeyEntryAttributesEntity> keyEntryAttributesMapEntry : persistentKeyEntries.entrySet()) {
            StsKeyEntry mappedKeyEntry = this.mapFromEntity(keyEntryAttributesMapEntry.getValue());
            mappedKeyEntries.put(mappedKeyEntry.getAlias(), mappedKeyEntry);
        }
        return mappedKeyEntries;
    }

    private StsKeyEntry mapFromEntity(KeyEntryAttributesEntity keyEntryAttributes) {
        return StsKeyEntryImpl.builder().alias(keyEntryAttributes.getAlias()).createdAt(this.convert(keyEntryAttributes.getCreatedAt())).notBefore(this.convert(keyEntryAttributes.getNotBefore())).notAfter(this.convert(keyEntryAttributes.getNotAfter())).expireAt(this.convert(keyEntryAttributes.getExpireAt())).validityInterval(keyEntryAttributes.getValidityInterval()).legacyInterval(keyEntryAttributes.getLegacyInterval()).state(keyEntryAttributes.getState()).keyUsage(keyEntryAttributes.getKeyUsage()).build();
    }

    public StsKeyStore mapFromEntity(KeyStoreEntity persistentKeyStore) {
        KeyStore orig = this.juggler.serializeDeserialize().deserialize(persistentKeyStore.getKeystore(), () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
        Map<String, StsKeyEntry> mappedKeyEntries = this.mapFromEntities(persistentKeyStore.getEntries());
        Date lastUpdate = persistentKeyStore.getLastUpdate();
        KeyStore keyStore = this.upgradeKeyStoreIfNeeded(orig, mappedKeyEntries);
        return StsKeyStore.builder().keyStore(keyStore).view(this.juggler.readKeys().fromKeyStore(keyStore, id -> this.keyPassHandler.getPassword()).entries()).lastUpdate(this.mapLastUpdate(lastUpdate)).build();
    }

    private KeyStore upgradeKeyStoreIfNeeded(KeyStore original, Map<String, StsKeyEntry> entries) {
        KeyStoreView view = this.juggler.readKeys().fromKeyStore(original, id -> this.keyPassHandler.getPassword());
        for (KeyEntry key : view.entries().all()) {
            if (null != key.getMeta()) continue;
            view.entries().remove((Object)key);
            view.entries().add((ProvidedKeyTemplate)ProvidedKeyEntry.builder().keyTemplate((KeyTemplate)new NameAndPassword(key.getAlias(), () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword())).entry(key.getEntry()).metadata((KeyMetadata)entries.get(key.getAlias())).build());
        }
        return original;
    }

    public ZonedDateTime mapLastUpdate(KeyStoreEntity keyStoreEntityWithLastUpdate) {
        Date lastUpdate = keyStoreEntityWithLastUpdate.getLastUpdate();
        return this.mapLastUpdate(lastUpdate);
    }

    private ZonedDateTime mapLastUpdate(Date lastUpdateAsDate) {
        if (lastUpdateAsDate == null) {
            return DEFAULT_LAST_UPDATE;
        }
        return this.convert(lastUpdateAsDate);
    }
}

