/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence.mongo.mapper;

import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.persistence.mongo.entity.KeyEntryAttributesEntity;
import de.adorsys.sts.persistence.mongo.entity.KeyStoreEntity;
import java.security.KeyStore;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeyStoreEntityMapper {
    private final PasswordCallbackHandler keyPassHandler;
    private final String keystoreName;

    @Autowired
    public KeyStoreEntityMapper(KeyManagementProperties keyManagementProperties) {
        String keyStorePassword = keyManagementProperties.getKeystore().getPassword();
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
        this.keystoreName = keyManagementProperties.getKeystore().getName();
    }

    public KeyStoreEntity mapToEntity(StsKeyStore keyStore) {
        KeyStoreEntity persistentKeyStore = new KeyStoreEntity();
        this.mapIntoEntity(keyStore, persistentKeyStore);
        return persistentKeyStore;
    }

    public void mapIntoEntity(StsKeyStore keyStore, KeyStoreEntity persistentKeyStore) {
        byte[] bytes = KeyStoreService.toByteArray((KeyStore)keyStore.getKeyStore(), (String)this.keystoreName, (CallbackHandler)this.keyPassHandler);
        persistentKeyStore.setName(this.keystoreName);
        persistentKeyStore.setKeystore(bytes);
        persistentKeyStore.setType(keyStore.getKeyStore().getType());
        Map<String, KeyEntryAttributesEntity> mappedEntryAttributes = this.mapToEntityMap(keyStore.getKeyEntries());
        persistentKeyStore.setEntries(mappedEntryAttributes);
    }

    private Map<String, KeyEntryAttributesEntity> mapToEntityMap(Map<String, StsKeyEntry> keyEntries) {
        return keyEntries.values().stream().map(this::mapToEntity).collect(Collectors.toMap(KeyEntryAttributesEntity::getAlias, Function.identity()));
    }

    private KeyEntryAttributesEntity mapToEntity(StsKeyEntry keyEntry) {
        KeyEntryAttributesEntity entryAttributes = new KeyEntryAttributesEntity();
        entryAttributes.setAlias(keyEntry.getAlias());
        entryAttributes.setCreatedAt(this.convert(keyEntry.getCreatedAt()));
        entryAttributes.setNotBefore(this.convert(keyEntry.getNotBefore()));
        entryAttributes.setNotAfter(this.convert(keyEntry.getNotAfter()));
        entryAttributes.setExpireAt(this.convert(keyEntry.getExpireAt()));
        entryAttributes.setValidityInterval(keyEntry.getValidityInterval());
        entryAttributes.setLegacyInterval(keyEntry.getLegacyInterval());
        entryAttributes.setState(keyEntry.getState());
        entryAttributes.setKeyUsage(keyEntry.getKeyUsage());
        return entryAttributes;
    }

    private Date convert(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return Date.from(zonedDateTime.toInstant());
    }

    private ZonedDateTime convert(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneOffset.UTC);
    }

    private Map<String, StsKeyEntry> mapFromEntities(KeyStore keyStore, Map<String, KeyEntryAttributesEntity> persistentKeyEntries) {
        HashMap<String, StsKeyEntry> mappedKeyEntries = new HashMap<String, StsKeyEntry>();
        Map keyEntries = KeyStoreService.loadEntryMap((KeyStore)keyStore, (KeyStoreService.PasswordProvider)new KeyStoreService.SimplePasswordProvider((CallbackHandler)this.keyPassHandler));
        for (Map.Entry<String, KeyEntryAttributesEntity> keyEntryAttributesMapEntry : persistentKeyEntries.entrySet()) {
            KeyEntry keyEntry = (KeyEntry)keyEntries.get(keyEntryAttributesMapEntry.getKey());
            StsKeyEntry mappedKeyEntry = this.mapFromEntity(keyEntry, keyEntryAttributesMapEntry.getValue());
            mappedKeyEntries.put(mappedKeyEntry.getAlias(), mappedKeyEntry);
        }
        return mappedKeyEntries;
    }

    private StsKeyEntry mapFromEntity(KeyEntry keyEntry, KeyEntryAttributesEntity keyEntryAttributes) {
        return StsKeyEntry.builder().alias(keyEntryAttributes.getAlias()).createdAt(this.convert(keyEntryAttributes.getCreatedAt())).notBefore(this.convert(keyEntryAttributes.getNotBefore())).notAfter(this.convert(keyEntryAttributes.getNotAfter())).expireAt(this.convert(keyEntryAttributes.getExpireAt())).validityInterval(keyEntryAttributes.getValidityInterval()).legacyInterval(keyEntryAttributes.getLegacyInterval()).state(keyEntryAttributes.getState()).keyUsage(keyEntryAttributes.getKeyUsage()).keyEntry(keyEntry).build();
    }

    public StsKeyStore mapFromEntity(KeyStoreEntity persistentKeyStore) {
        KeyStore keyStore = KeyStoreService.loadKeyStore((byte[])persistentKeyStore.getKeystore(), (String)this.keystoreName, (KeyStoreType)new KeyStoreType(persistentKeyStore.getType()), (CallbackHandler)this.keyPassHandler);
        Map<String, StsKeyEntry> mappedKeyEntries = this.mapFromEntities(keyStore, persistentKeyStore.getEntries());
        return StsKeyStore.builder().keyStore(keyStore).keyEntries(mappedKeyEntries).build();
    }
}

