/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.persistence.mongo;

import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.persistence.mongo.entity.KeyStoreEntity;
import de.adorsys.sts.persistence.mongo.mapper.KeyStoreEntityMapper;
import de.adorsys.sts.persistence.mongo.repository.MongoKeyStoreRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MongoDatabaseKeyStoreRepository
implements KeyStoreRepository {
    private final MongoKeyStoreRepository keyStoreRepository;
    private final KeyStoreEntityMapper keyStoreEntityMapper;
    private final String keyStoreName;

    @Autowired
    public MongoDatabaseKeyStoreRepository(MongoKeyStoreRepository keyStoreRepository, KeyStoreEntityMapper keyStoreEntityMapper, KeyManagementProperties keyManagementProperties) {
        this.keyStoreRepository = keyStoreRepository;
        this.keyStoreEntityMapper = keyStoreEntityMapper;
        this.keyStoreName = keyManagementProperties.getKeystore().getName();
    }

    public StsKeyStore load() {
        KeyStoreEntity persistentKeyStore = this.keyStoreRepository.findByName(this.keyStoreName);
        return this.keyStoreEntityMapper.mapFromEntity(persistentKeyStore);
    }

    public boolean exists() {
        return this.keyStoreRepository.countByName(this.keyStoreName) > 0L;
    }

    public void save(StsKeyStore keyStore) {
        KeyStoreEntity foundKeyStore = this.keyStoreRepository.findByName(this.keyStoreName);
        if (foundKeyStore == null) {
            foundKeyStore = this.keyStoreEntityMapper.mapToEntity(keyStore);
            this.keyStoreRepository.save(foundKeyStore);
        } else {
            this.keyStoreEntityMapper.mapIntoEntity(keyStore, foundKeyStore);
            this.keyStoreRepository.save(foundKeyStore);
        }
    }
}

