/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import java.security.KeyStore;
import javax.annotation.PostConstruct;
import org.adorsys.jjwk.serverkey.KeyConverter;
import org.adorsys.jjwk.serverkey.ServerKeyMap;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.adorsys.jjwk.serverkey.ServerKeysHolder;

public class KeyManagementService
implements ServerKeyMapProvider {
    private final KeyStoreRepository repository;
    private final KeyStoreGenerator keyStoreGenerator;
    private final String keyStorePassword;
    private KeyStore keyStore;

    public KeyManagementService(KeyStoreRepository repository, KeyStoreGenerator keyStoreGenerator, String keyStorePassword) {
        this.repository = repository;
        this.keyStoreGenerator = keyStoreGenerator;
        this.keyStorePassword = keyStorePassword;
    }

    @PostConstruct
    public void postConstruct() {
        if (this.repository.exists()) {
            this.keyStore = this.repository.load();
        } else {
            this.keyStore = this.keyStoreGenerator.generate();
            this.repository.save(this.keyStore);
        }
    }

    public ServerKeyMap getKeyMap() {
        return new ServerKeyMap(this.getServerKeysHolder().getPrivateKeySet());
    }

    public ServerKeysHolder getServerKeysHolder() {
        JWKSet privateKeys = KeyConverter.exportPrivateKeys((KeyStore)this.keyStore, (char[])this.keyStorePassword.toCharArray());
        JWKSet publicKeys = privateKeys.toPublicJWKSet();
        return new ServerKeysHolder(privateKeys, publicKeys);
    }
}

