/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.keymanagement.config.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import java.security.KeyStore;
import java.util.UUID;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.KeyEntryData;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.apache.commons.lang3.RandomStringUtils;

public class KeyStoreGenerator {
    private final KeyPairGenerator encKeyPairGenerator;
    private final KeyPairGenerator signKeyPairGenerator;
    private final SecretKeyGenerator secretKeyGenerator;
    private final String keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final Integer numberOfSignKeyPairs;
    private final Integer numberOfEncKeyPairs;
    private final Integer numberOfSecretKeys;
    private final CallbackHandler keyPassHandler;

    public KeyStoreGenerator(KeyPairGenerator encKeyPairGenerator, KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, String keyStoreType, String serverKeyPairAliasPrefix, Integer numberOfSignKeyPairs, Integer numberOfEncKeyPairs, Integer numberOfSecretKeys, String keyStorePassword) {
        this.encKeyPairGenerator = encKeyPairGenerator;
        this.signKeyPairGenerator = signKeyPairGenerator;
        this.secretKeyGenerator = secretKeyGenerator;
        this.keyStoreType = keyStoreType;
        this.serverKeyPairAliasPrefix = serverKeyPairAliasPrefix;
        this.numberOfSignKeyPairs = numberOfSignKeyPairs;
        this.numberOfEncKeyPairs = numberOfEncKeyPairs;
        this.numberOfSecretKeys = numberOfSecretKeys;
        this.keyPassHandler = new PasswordCallbackHandler(keyStorePassword.toCharArray());
    }

    public KeyStoreGenerator(KeyPairGenerator encKeyPairGenerator, KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementProperties keyManagementProperties) {
        this.encKeyPairGenerator = encKeyPairGenerator;
        this.signKeyPairGenerator = signKeyPairGenerator;
        this.secretKeyGenerator = secretKeyGenerator;
        KeyManagementProperties.KeyStoreProperties keystoreProperties = keyManagementProperties.getKeystore();
        this.keyStoreType = keystoreProperties.getType();
        this.serverKeyPairAliasPrefix = keystoreProperties.getAliasPrefix();
        KeyManagementProperties.KeyStoreProperties.KeysProperties keysProperties = keystoreProperties.getKeys();
        this.numberOfSignKeyPairs = keysProperties.getSignKeyPairs().getInitialCount();
        this.numberOfEncKeyPairs = keysProperties.getEncKeyPairs().getInitialCount();
        this.numberOfSecretKeys = keysProperties.getSecretKeys().getInitialCount();
        String password = keystoreProperties.getPassword();
        this.keyPassHandler = new PasswordCallbackHandler(password.toCharArray());
    }

    public KeyStore generate() {
        try {
            KeyPairData signatureKeyPair;
            int i;
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            for (i = 0; i < this.numberOfSignKeyPairs; ++i) {
                signatureKeyPair = this.signKeyPairGenerator.generateSignatureKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), this.keyPassHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntryData)signatureKeyPair);
            }
            for (i = 0; i < this.numberOfEncKeyPairs; ++i) {
                signatureKeyPair = this.encKeyPairGenerator.generateEncryptionKey(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), this.keyPassHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntryData)signatureKeyPair);
            }
            for (i = 0; i < this.numberOfSecretKeys; ++i) {
                SecretKeyData secretKeyData = this.secretKeyGenerator.generate(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), this.keyPassHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntryData)secretKeyData);
            }
            return keystoreBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

