/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.model;

import de.adorsys.sts.cryptoutils.KeyEntry;
import de.adorsys.sts.cryptoutils.KeyStoreService;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.time.ZonedDateTime;
import java.util.Map;

public class StsKeyStore {
    private final Map<String, StsKeyEntry> keyEntries;
    private final KeyStore keyStore;
    private ZonedDateTime lastUpdate;

    public void addKey(StsKeyEntry keyEntry) {
        KeyStoreService.addToKeyStore((KeyStore)this.keyStore, (KeyEntry)keyEntry.getKeyEntry());
        this.keyEntries.put(keyEntry.getAlias(), keyEntry);
    }

    public void removeKey(String keyAlias) {
        this.keyEntries.remove(keyAlias);
        try {
            this.keyStore.deleteEntry(keyAlias);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    StsKeyStore(Map<String, StsKeyEntry> keyEntries, KeyStore keyStore, ZonedDateTime lastUpdate) {
        this.keyEntries = keyEntries;
        this.keyStore = keyStore;
        this.lastUpdate = lastUpdate;
    }

    public static StsKeyStoreBuilder builder() {
        return new StsKeyStoreBuilder();
    }

    public Map<String, StsKeyEntry> getKeyEntries() {
        return this.keyEntries;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public static class StsKeyStoreBuilder {
        private Map<String, StsKeyEntry> keyEntries;
        private KeyStore keyStore;
        private ZonedDateTime lastUpdate;

        StsKeyStoreBuilder() {
        }

        public StsKeyStoreBuilder keyEntries(Map<String, StsKeyEntry> keyEntries) {
            this.keyEntries = keyEntries;
            return this;
        }

        public StsKeyStoreBuilder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public StsKeyStoreBuilder lastUpdate(ZonedDateTime lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public StsKeyStore build() {
            return new StsKeyStore(this.keyEntries, this.keyStore, this.lastUpdate);
        }

        public String toString() {
            return "StsKeyStore.StsKeyStoreBuilder(keyEntries=" + this.keyEntries + ", keyStore=" + this.keyStore + ", lastUpdate=" + this.lastUpdate + ")";
        }
    }
}

