/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.cryptoutils.KeyEntry;
import de.adorsys.sts.cryptoutils.KeyPairEntry;
import de.adorsys.sts.cryptoutils.KeyStoreType;
import de.adorsys.sts.cryptoutils.KeystoreBuilder;
import de.adorsys.sts.cryptoutils.PasswordCallbackHandler;
import de.adorsys.sts.cryptoutils.SecretKeyEntry;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import de.adorsys.sts.keymanagement.util.DateTimeUtils;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.RandomStringUtils;

public class KeyStoreGenerator {
    private final Clock clock;
    private final KeyPairGenerator encKeyPairGenerator;
    private final KeyPairGenerator signKeyPairGenerator;
    private final SecretKeyGenerator secretKeyGenerator;
    private final KeyStoreType keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final CallbackHandler keyPassHandler;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties encKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties signKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties secretKeyProperties;

    public KeyStoreGenerator(Clock clock, KeyPairGenerator encKeyPairGenerator, KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementProperties keyManagementProperties) {
        this.clock = clock;
        this.encKeyPairGenerator = encKeyPairGenerator;
        this.signKeyPairGenerator = signKeyPairGenerator;
        this.secretKeyGenerator = secretKeyGenerator;
        KeyManagementProperties.KeyStoreProperties keystoreProperties = keyManagementProperties.getKeystore();
        this.keyStoreType = new KeyStoreType(keystoreProperties.getType());
        this.serverKeyPairAliasPrefix = keystoreProperties.getAliasPrefix();
        String password = keystoreProperties.getPassword();
        this.encKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getEncKeyPairs();
        this.signKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getSignKeyPairs();
        this.secretKeyProperties = keyManagementProperties.getKeystore().getKeys().getSecretKeys();
        this.keyPassHandler = new PasswordCallbackHandler(password.toCharArray());
    }

    public StsKeyStore generate() {
        HashMap<String, StsKeyEntry> keyEntries = new HashMap<String, StsKeyEntry>();
        try {
            int i;
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            for (i = 0; i < this.signKeyPairsProperties.getInitialCount(); ++i) {
                StsKeyEntry signKeyPair = this.generateSignatureKeyEntryForInstantUsage();
                keystoreBuilder = keystoreBuilder.withKeyEntry(signKeyPair.getKeyEntry());
                keyEntries.put(signKeyPair.getAlias(), signKeyPair);
                signKeyPair = this.generateSignatureKeyEntryForFutureUsage(signKeyPair.getNotAfter());
                keystoreBuilder = keystoreBuilder.withKeyEntry(signKeyPair.getKeyEntry());
                keyEntries.put(signKeyPair.getAlias(), signKeyPair);
            }
            for (i = 0; i < this.encKeyPairsProperties.getInitialCount(); ++i) {
                StsKeyEntry encryptionKeyPair = this.generateEncryptionKeyEntryForInstantUsage();
                keystoreBuilder = keystoreBuilder.withKeyEntry(encryptionKeyPair.getKeyEntry());
                keyEntries.put(encryptionKeyPair.getAlias(), encryptionKeyPair);
                encryptionKeyPair = this.generateEncryptionKeyEntryForFutureUsage(encryptionKeyPair.getNotAfter());
                keystoreBuilder = keystoreBuilder.withKeyEntry(encryptionKeyPair.getKeyEntry());
                keyEntries.put(encryptionKeyPair.getAlias(), encryptionKeyPair);
            }
            for (i = 0; i < this.secretKeyProperties.getInitialCount(); ++i) {
                StsKeyEntry secretKey = this.generateSecretKeyEntryForInstantUsage();
                keystoreBuilder = keystoreBuilder.withKeyEntry(secretKey.getKeyEntry());
                keyEntries.put(secretKey.getAlias(), secretKey);
                secretKey = this.generateSecretKeyEntryForFutureUsage(secretKey.getNotAfter());
                keystoreBuilder = keystoreBuilder.withKeyEntry(secretKey.getKeyEntry());
                keyEntries.put(secretKey.getAlias(), secretKey);
            }
            return StsKeyStore.builder().keyEntries(keyEntries).keyStore(keystoreBuilder.build()).lastUpdate(this.now()).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public StsKeyEntry generateKeyEntryForFutureUsage(KeyUsage keyUsage, ZonedDateTime notBefore) {
        StsKeyEntry generatedKeyEntry;
        if (keyUsage == KeyUsage.Encryption) {
            generatedKeyEntry = this.generateEncryptionKeyEntryForFutureUsage(notBefore);
        } else if (keyUsage == KeyUsage.Signature) {
            generatedKeyEntry = this.generateSignatureKeyEntryForFutureUsage(notBefore);
        } else if (keyUsage == KeyUsage.SecretKey) {
            generatedKeyEntry = this.generateSecretKeyEntryForFutureUsage(notBefore);
        } else {
            throw new IllegalArgumentException("unknown KeyUsage: " + keyUsage.name());
        }
        return generatedKeyEntry;
    }

    public StsKeyEntry generateSignatureKeyEntryForInstantUsage() {
        KeyPairEntry signatureKeyPair = this.generateSignKeyPair();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(signatureKeyPair.getAlias()).createdAt(now).notBefore(now).validityInterval(this.signKeyPairsProperties.getValidityInterval()).legacyInterval(this.signKeyPairsProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.signKeyPairsProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.signKeyPairsProperties.getLegacyInterval())).keyUsage(KeyUsage.Signature).state(StsKeyEntry.State.VALID).keyEntry((KeyEntry)signatureKeyPair).build();
    }

    public StsKeyEntry generateSignatureKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        KeyPairEntry signatureKeyPair = this.generateSignKeyPair();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(signatureKeyPair.getAlias()).createdAt(now).notBefore(notBefore).validityInterval(this.signKeyPairsProperties.getValidityInterval()).legacyInterval(this.signKeyPairsProperties.getLegacyInterval()).keyUsage(KeyUsage.Signature).state(StsKeyEntry.State.CREATED).keyEntry((KeyEntry)signatureKeyPair).build();
    }

    private KeyPairEntry generateSignKeyPair() {
        String alias = this.serverKeyPairAliasPrefix + UUID.randomUUID().toString();
        return this.signKeyPairGenerator.generateSignatureKey(alias, this.keyPassHandler);
    }

    public StsKeyEntry generateEncryptionKeyEntryForInstantUsage() {
        KeyPairEntry signatureKeyPair = this.generateEncryptionKeyPair();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(signatureKeyPair.getAlias()).createdAt(now).notBefore(now).validityInterval(this.encKeyPairsProperties.getValidityInterval()).legacyInterval(this.encKeyPairsProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.encKeyPairsProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.encKeyPairsProperties.getLegacyInterval())).keyUsage(KeyUsage.Encryption).state(StsKeyEntry.State.VALID).keyEntry((KeyEntry)signatureKeyPair).build();
    }

    public StsKeyEntry generateEncryptionKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        KeyPairEntry encryptionKeyPair = this.generateEncryptionKeyPair();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(encryptionKeyPair.getAlias()).createdAt(now).notBefore(notBefore).validityInterval(this.encKeyPairsProperties.getValidityInterval()).legacyInterval(this.encKeyPairsProperties.getLegacyInterval()).keyUsage(KeyUsage.Encryption).state(StsKeyEntry.State.CREATED).keyEntry((KeyEntry)encryptionKeyPair).build();
    }

    private KeyPairEntry generateEncryptionKeyPair() {
        String alias = this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase();
        return this.encKeyPairGenerator.generateEncryptionKey(alias, this.keyPassHandler);
    }

    public StsKeyEntry generateSecretKeyEntryForInstantUsage() {
        SecretKeyEntry secretKeyData = this.generateSecretKey();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(secretKeyData.getAlias()).createdAt(now).notBefore(now).validityInterval(this.secretKeyProperties.getValidityInterval()).legacyInterval(this.secretKeyProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.secretKeyProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.secretKeyProperties.getLegacyInterval())).keyUsage(KeyUsage.SecretKey).state(StsKeyEntry.State.VALID).keyEntry((KeyEntry)secretKeyData).build();
    }

    public StsKeyEntry generateSecretKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        SecretKeyEntry secretKeyData = this.generateSecretKey();
        ZonedDateTime now = this.now();
        return StsKeyEntry.builder().alias(secretKeyData.getAlias()).createdAt(now).notBefore(notBefore).validityInterval(this.secretKeyProperties.getValidityInterval()).legacyInterval(this.secretKeyProperties.getLegacyInterval()).keyUsage(KeyUsage.SecretKey).state(StsKeyEntry.State.CREATED).keyEntry((KeyEntry)secretKeyData).build();
    }

    private SecretKeyEntry generateSecretKey() {
        String alias = this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase();
        return this.secretKeyGenerator.generate(alias, this.keyPassHandler);
    }

    private ZonedDateTime now() {
        return this.clock.instant().atZone(ZoneOffset.UTC);
    }
}

