/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.persistence;

import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import java.time.ZonedDateTime;

public class CachedKeyStoreRepository
implements KeyStoreRepository {
    private final KeyStoreRepository keyStoreRepository;
    private StsKeyStore cachedKeyStore;

    public CachedKeyStoreRepository(KeyStoreRepository keyStoreRepository) {
        this.keyStoreRepository = keyStoreRepository;
    }

    @Override
    public StsKeyStore load() {
        if (this.cachedKeyStore == null) {
            this.cachedKeyStore = this.keyStoreRepository.load();
        } else {
            ZonedDateTime cachedLastUpdate;
            ZonedDateTime lastUpdate = this.keyStoreRepository.lastUpdate();
            if (lastUpdate.isAfter(cachedLastUpdate = this.cachedKeyStore.getLastUpdate())) {
                this.cachedKeyStore = this.keyStoreRepository.load();
            }
        }
        return this.cachedKeyStore;
    }

    @Override
    public boolean exists() {
        return this.cachedKeyStore != null || this.keyStoreRepository.exists();
    }

    @Override
    public void save(StsKeyStore keyStore) {
        this.keyStoreRepository.save(keyStore);
        this.cachedKeyStore = keyStore;
    }

    @Override
    public ZonedDateTime lastUpdate() {
        return this.keyStoreRepository.lastUpdate();
    }
}

