/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import de.adorsys.sts.keymanagement.service.SecretDecryptionException;
import java.security.Key;
import java.text.ParseException;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;

public class DecryptionService {
    private final ServerKeyMapProvider keyMapProvider;
    private final DefaultJWEDecrypterFactory decrypterFactory = new DefaultJWEDecrypterFactory();

    public DecryptionService(ServerKeyMapProvider keyMapProvider) {
        this.keyMapProvider = keyMapProvider;
    }

    public String decrypt(String encrypted) throws SecretDecryptionException {
        JWEDecrypter decrypter;
        JWEObject jweObject;
        try {
            jweObject = JWEObject.parse((String)encrypted);
        }
        catch (ParseException e) {
            throw new SecretDecryptionException(e);
        }
        String keyID = jweObject.getHeader().getKeyID();
        Key key = this.keyMapProvider.getKey(keyID);
        if (key == null) {
            throw new IllegalStateException("No suitable key found");
        }
        try {
            decrypter = this.decrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
        }
        catch (JOSEException e) {
            throw new SecretDecryptionException(e);
        }
        try {
            jweObject.decrypt(decrypter);
        }
        catch (JOSEException e) {
            throw new SecretDecryptionException(e);
        }
        return jweObject.getPayload().toString();
    }
}

