/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.sts.common.util.ImmutableLists;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyMap;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.adorsys.jjwk.serverkey.ServerKeysHolder;

public class KeyManagementService
implements ServerKeyMapProvider {
    private static final JWKSet EMPTY_JWK_SET = new JWKSet(ImmutableLists.emptyList());
    private static final ServerKeysHolder EMPTY_KEYS = new ServerKeysHolder(EMPTY_JWK_SET, EMPTY_JWK_SET);
    private final KeyStoreRepository repository;
    private final KeyConversionService keyConversionService;

    public KeyManagementService(KeyStoreRepository repository, KeyConversionService keyConversionService) {
        this.repository = repository;
        this.keyConversionService = keyConversionService;
    }

    public ServerKeyMap getKeyMap() {
        throw new IllegalStateException("Method not supported");
    }

    public ServerKeysHolder getServerKeysHolder() {
        throw new IllegalStateException("Method not supported");
    }

    public KeyAndJwk randomSecretKey() {
        return this.getSecretKeys().randomSecretKey();
    }

    public KeyAndJwk randomSignKey() {
        return this.getPrivateKeys().randomSignKey();
    }

    public Key getKey(String keyId) {
        ServerKeyMap serverKeyMap = new ServerKeyMap(this.loadKeys().getPrivateKeySet());
        return serverKeyMap.getKey(keyId);
    }

    private ServerKeysHolder loadKeys() {
        ServerKeysHolder exportedKeys = this.repository.exists() ? this.keyConversionService.export(this.repository.load().getKeyStore()) : EMPTY_KEYS;
        return exportedKeys;
    }

    public JWKSet getPublicKeys() {
        if (this.repository.exists()) {
            StsKeyStore keyStore = this.repository.load();
            ServerKeysHolder exportedKeys = this.keyConversionService.export(keyStore.getKeyStore());
            Map<String, StsKeyEntry> keyEntries = keyStore.getKeyEntries();
            List filteredKeyAliases = keyEntries.values().stream().filter(this::hasUsablePublicKey).map(StsKeyEntry::getAlias).collect(Collectors.toList());
            List filteredKeys = exportedKeys.getPublicKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
            return new JWKSet(filteredKeys);
        }
        return EMPTY_JWK_SET;
    }

    private ServerKeyMap getPrivateKeys() {
        return new ServerKeyMap(this.getFilteredPrivateKeys(this::hasUsablePrivateKey));
    }

    private ServerKeyMap getSecretKeys() {
        return new ServerKeyMap(this.getFilteredPrivateKeys(this::isUsableSecretKey));
    }

    private JWKSet getFilteredPrivateKeys(Predicate<StsKeyEntry> predicate) {
        if (this.repository.exists()) {
            StsKeyStore keyStore = this.repository.load();
            ServerKeysHolder exportedKeys = this.keyConversionService.export(keyStore.getKeyStore());
            Map<String, StsKeyEntry> keyEntries = keyStore.getKeyEntries();
            List filteredKeyAliases = keyEntries.values().stream().filter(predicate).map(StsKeyEntry::getAlias).collect(Collectors.toList());
            List filteredKeys = exportedKeys.getPrivateKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
            return new JWKSet(filteredKeys);
        }
        return EMPTY_JWK_SET;
    }

    private boolean hasUsablePublicKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && stsKeyEntry.getState() == StsKeyEntry.State.VALID || stsKeyEntry.getKeyUsage() == KeyUsage.Signature && (stsKeyEntry.getState() == StsKeyEntry.State.VALID || stsKeyEntry.getState() == StsKeyEntry.State.LEGACY);
    }

    private boolean hasUsablePrivateKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Signature && stsKeyEntry.getState() == StsKeyEntry.State.VALID || stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && (stsKeyEntry.getState() == StsKeyEntry.State.VALID || stsKeyEntry.getState() == StsKeyEntry.State.LEGACY);
    }

    private boolean isUsableSecretKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.SecretKey && stsKeyEntry.getState() == StsKeyEntry.State.VALID;
    }
}

