/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyPairEntry;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.SecretKeyEntry;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.apache.commons.lang3.RandomStringUtils;

public class KeyStoreGenerator {
    private final KeyPairGenerator encKeyPairGenerator;
    private final KeyPairGenerator signKeyPairGenerator;
    private final SecretKeyGenerator secretKeyGenerator;
    private final String keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final CallbackHandler keyPassHandler;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties encKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties signKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties secretKeyProperties;

    public KeyStoreGenerator(KeyPairGenerator encKeyPairGenerator, KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementProperties keyManagementProperties) {
        this.encKeyPairGenerator = encKeyPairGenerator;
        this.signKeyPairGenerator = signKeyPairGenerator;
        this.secretKeyGenerator = secretKeyGenerator;
        KeyManagementProperties.KeyStoreProperties keystoreProperties = keyManagementProperties.getKeystore();
        this.keyStoreType = keystoreProperties.getType();
        this.serverKeyPairAliasPrefix = keystoreProperties.getAliasPrefix();
        String password = keystoreProperties.getPassword();
        this.encKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getEncKeyPairs();
        this.signKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getSignKeyPairs();
        this.secretKeyProperties = keyManagementProperties.getKeystore().getKeys().getSecretKeys();
        this.keyPassHandler = new PasswordCallbackHandler(password.toCharArray());
    }

    public StsKeyStore generate() {
        HashMap<String, StsKeyEntry> keyEntries = new HashMap<String, StsKeyEntry>();
        try {
            int i;
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            for (i = 0; i < this.signKeyPairsProperties.getInitialCount(); ++i) {
                StsKeyEntry signKeyPair = this.generateSignKeyPair();
                keystoreBuilder = keystoreBuilder.withKeyEntry(signKeyPair.getKeyEntry());
                keyEntries.put(signKeyPair.getAlias(), signKeyPair);
            }
            for (i = 0; i < this.encKeyPairsProperties.getInitialCount(); ++i) {
                StsKeyEntry encryptionKeyPair = this.generateEncryptionKeyPair();
                keystoreBuilder = keystoreBuilder.withKeyEntry(encryptionKeyPair.getKeyEntry());
                keyEntries.put(encryptionKeyPair.getAlias(), encryptionKeyPair);
            }
            for (i = 0; i < this.secretKeyProperties.getInitialCount(); ++i) {
                StsKeyEntry secretKey = this.generateSecretKey();
                keystoreBuilder = keystoreBuilder.withKeyEntry(secretKey.getKeyEntry());
                keyEntries.put(secretKey.getAlias(), secretKey);
            }
            return StsKeyStore.builder().keyEntries(keyEntries).keyStore(keystoreBuilder.build()).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public StsKeyEntry generateSignKeyPair() {
        String alias = this.serverKeyPairAliasPrefix + UUID.randomUUID().toString();
        KeyPairEntry signatureKeyPair = this.signKeyPairGenerator.generateSignatureKey(alias, this.keyPassHandler);
        KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties signKeyRotationProperties = this.signKeyPairsProperties.getRotation();
        return StsKeyEntry.builder().alias(alias).createdAt(this.now()).validityInterval(signKeyRotationProperties.getValidityInterval()).legacyInterval(signKeyRotationProperties.getLegacyInterval()).keyUsage(KeyUsage.Signature).keyEntry((KeyEntry)signatureKeyPair).build();
    }

    public StsKeyEntry generateEncryptionKeyPair() {
        String alias = this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase();
        KeyPairEntry signatureKeyPair = this.encKeyPairGenerator.generateEncryptionKey(alias, this.keyPassHandler);
        KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties encKeyRotationProperties = this.encKeyPairsProperties.getRotation();
        return StsKeyEntry.builder().alias(alias).createdAt(this.now()).validityInterval(encKeyRotationProperties.getValidityInterval()).legacyInterval(encKeyRotationProperties.getLegacyInterval()).keyUsage(KeyUsage.Encryption).keyEntry((KeyEntry)signatureKeyPair).build();
    }

    public StsKeyEntry generateSecretKey() {
        String alias = this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase();
        SecretKeyEntry secretKeyData = this.secretKeyGenerator.generate(alias, this.keyPassHandler);
        KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties secretKeyRotationProperties = this.secretKeyProperties.getRotation();
        return StsKeyEntry.builder().alias(alias).createdAt(this.now()).validityInterval(secretKeyRotationProperties.getValidityInterval()).legacyInterval(secretKeyRotationProperties.getLegacyInterval()).keyUsage(KeyUsage.SecretKey).keyEntry((KeyEntry)secretKeyData).build();
    }

    private ZonedDateTime now() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }
}

