/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KeyStoreFilter {
    private final Clock clock;
    private final Predicate<StsKeyEntry> IsValid = new Predicate<StsKeyEntry>(){

        @Override
        public boolean test(StsKeyEntry attributes) {
            ZonedDateTime createdAt = attributes.getCreatedAt();
            Long validityInterval = attributes.getValidityInterval();
            Instant invalidAt = createdAt.toInstant().plusMillis(validityInterval);
            return KeyStoreFilter.this.clock.instant().isBefore(invalidAt);
        }
    };
    private final Predicate<StsKeyEntry> IsLegacy = new Predicate<StsKeyEntry>(){

        @Override
        public boolean test(StsKeyEntry attributes) {
            ZonedDateTime createdAt = attributes.getCreatedAt();
            Long validityInterval = attributes.getValidityInterval();
            Long legacyInterval = attributes.getLegacyInterval();
            Instant invalidAt = createdAt.toInstant().plusMillis(validityInterval).plusMillis(legacyInterval);
            Instant legacySince = createdAt.toInstant().plusMillis(legacyInterval);
            Instant clockInstant = KeyStoreFilter.this.clock.instant();
            return clockInstant.isAfter(legacySince) && clockInstant.isBefore(invalidAt);
        }
    };

    public KeyStoreFilter(Clock clock) {
        this.clock = clock;
    }

    public List<String> filterLegacy(Collection<StsKeyEntry> keyAliases) {
        return keyAliases.stream().filter(this.IsLegacy).map(StsKeyEntry::getAlias).collect(Collectors.toList());
    }

    public List<String> filterValid(Collection<StsKeyEntry> keyEntries) {
        return keyEntries.stream().filter(this.IsValid).map(StsKeyEntry::getAlias).collect(Collectors.toList());
    }

    public boolean isLegacy(StsKeyEntry keyEntry) {
        return this.IsLegacy.test(keyEntry);
    }

    public boolean isValid(StsKeyEntry keyEntry) {
        return this.IsValid.test(keyEntry);
    }

    public boolean isInvalid(StsKeyEntry keyEntry) {
        return !this.IsValid.test(keyEntry) && !this.IsLegacy.test(keyEntry);
    }
}

