/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyStoreFilter;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class KeyRotationService {
    private final KeyStoreFilter keyStoreFilter;
    private final KeyStoreGenerator keyStoreGenerator;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties encryptionKeyPairRotationProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties signatureKeyPairRotationProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties secretKeyRotationProperties;

    public KeyRotationService(KeyStoreFilter keyStoreFilter, KeyStoreGenerator keyStoreGenerator, KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties encryptionKeyPairRotationProperties, KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties signatureKeyPairRotationProperties, KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyRotationProperties secretKeyRotationProperties) {
        this.keyStoreFilter = keyStoreFilter;
        this.keyStoreGenerator = keyStoreGenerator;
        this.encryptionKeyPairRotationProperties = encryptionKeyPairRotationProperties;
        this.signatureKeyPairRotationProperties = signatureKeyPairRotationProperties;
        this.secretKeyRotationProperties = secretKeyRotationProperties;
    }

    public KeyRotationResult rotate(StsKeyStore stsKeyStore) {
        List<String> removedKeys = this.removeExpiredKeys(stsKeyStore);
        List<String> generatedKeyAliases = this.generateAndAddMissingKeys(stsKeyStore);
        return KeyRotationResult.builder().generatedKeys(generatedKeyAliases).removedKeys(removedKeys).build();
    }

    private List<String> removeExpiredKeys(StsKeyStore stsKeyStore) {
        ArrayList<String> removedKeys = new ArrayList<String>();
        if (this.encryptionKeyPairRotationProperties.isEnabled().booleanValue()) {
            removedKeys.addAll(this.removeExpiredKeys(stsKeyStore, KeyUsage.Encryption));
        }
        if (this.signatureKeyPairRotationProperties.isEnabled().booleanValue()) {
            removedKeys.addAll(this.removeExpiredKeys(stsKeyStore, KeyUsage.Signature));
        }
        if (this.secretKeyRotationProperties.isEnabled().booleanValue()) {
            removedKeys.addAll(this.removeExpiredKeys(stsKeyStore, KeyUsage.SecretKey));
        }
        return removedKeys;
    }

    private List<String> removeExpiredKeys(StsKeyStore stsKeyStore, KeyUsage keyUsage) {
        Collection<StsKeyEntry> actualKeys = stsKeyStore.getKeyEntries().values();
        ArrayList<StsKeyEntry> copiedKeyEntries = new ArrayList<StsKeyEntry>(actualKeys);
        return copiedKeyEntries.stream().filter(this.keyStoreFilter::isInvalid).filter(k -> k.getKeyUsage() == keyUsage).map(k -> this.removeKey(stsKeyStore, (StsKeyEntry)k)).collect(Collectors.toList());
    }

    private List<String> generateAndAddMissingKeys(StsKeyStore stsKeyStore) {
        Collection<StsKeyEntry> actualKeys = stsKeyStore.getKeyEntries().values();
        List<StsKeyEntry> generatedKeys = this.generateMissingKeys(actualKeys);
        ArrayList<String> generatedKeyAliases = new ArrayList<String>();
        for (StsKeyEntry generatedKey : generatedKeys) {
            stsKeyStore.addKey(generatedKey);
            generatedKeyAliases.add(generatedKey.getAlias());
        }
        return generatedKeyAliases;
    }

    private List<StsKeyEntry> generateMissingKeys(Collection<StsKeyEntry> actualKeys) {
        ArrayList<StsKeyEntry> generatedKeys = new ArrayList<StsKeyEntry>();
        if (this.encryptionKeyPairRotationProperties.isEnabled().booleanValue()) {
            generatedKeys.addAll(this.generateMissingEncryptionKeys(actualKeys));
        }
        if (this.signatureKeyPairRotationProperties.isEnabled().booleanValue()) {
            generatedKeys.addAll(this.generateMissingSignatureKeys(actualKeys));
        }
        if (this.secretKeyRotationProperties.isEnabled().booleanValue()) {
            generatedKeys.addAll(this.generateMissingSecretKeys(actualKeys));
        }
        return generatedKeys;
    }

    private List<StsKeyEntry> generateMissingEncryptionKeys(Collection<StsKeyEntry> actualKeys) {
        ArrayList<StsKeyEntry> generatedKeys = new ArrayList<StsKeyEntry>();
        long countOfValidEncryptionKeyPairs = actualKeys.stream().filter(this.keyStoreFilter::isValid).filter(k -> k.getKeyUsage() == KeyUsage.Encryption).count();
        int i = 0;
        while ((long)i < (long)this.encryptionKeyPairRotationProperties.getMinKeys().intValue() - countOfValidEncryptionKeyPairs) {
            StsKeyEntry generatedKeyAlias = this.generateKey(KeyUsage.Encryption);
            generatedKeys.add(generatedKeyAlias);
            ++i;
        }
        return generatedKeys;
    }

    private List<StsKeyEntry> generateMissingSignatureKeys(Collection<StsKeyEntry> actualKeys) {
        ArrayList<StsKeyEntry> generatedKeys = new ArrayList<StsKeyEntry>();
        long countOfValidSignatureKeyPairs = actualKeys.stream().filter(this.keyStoreFilter::isValid).filter(k -> k.getKeyUsage() == KeyUsage.Signature).count();
        int i = 0;
        while ((long)i < (long)this.signatureKeyPairRotationProperties.getMinKeys().intValue() - countOfValidSignatureKeyPairs) {
            StsKeyEntry generatedKeyAlias = this.generateKey(KeyUsage.Signature);
            generatedKeys.add(generatedKeyAlias);
            ++i;
        }
        return generatedKeys;
    }

    private List<StsKeyEntry> generateMissingSecretKeys(Collection<StsKeyEntry> actualKeys) {
        ArrayList<StsKeyEntry> generatedKeys = new ArrayList<StsKeyEntry>();
        long countOfValidSecretKeys = actualKeys.stream().filter(this.keyStoreFilter::isValid).filter(k -> k.getKeyUsage() == KeyUsage.SecretKey).count();
        int i = 0;
        while ((long)i < (long)this.secretKeyRotationProperties.getMinKeys().intValue() - countOfValidSecretKeys) {
            StsKeyEntry generatedKeyAlias = this.generateKey(KeyUsage.SecretKey);
            generatedKeys.add(generatedKeyAlias);
            ++i;
        }
        return generatedKeys;
    }

    private String removeKey(StsKeyStore keyStore, StsKeyEntry stsKeyEntry) {
        String alias = stsKeyEntry.getAlias();
        keyStore.removeKey(alias);
        return alias;
    }

    private StsKeyEntry generateKey(KeyUsage keyUsage) {
        StsKeyEntry stsKeyEntry;
        if (keyUsage == KeyUsage.Signature) {
            stsKeyEntry = this.keyStoreGenerator.generateSignKeyPair();
        } else if (keyUsage == KeyUsage.Encryption) {
            stsKeyEntry = this.keyStoreGenerator.generateEncryptionKeyPair();
        } else if (keyUsage == KeyUsage.SecretKey) {
            stsKeyEntry = this.keyStoreGenerator.generateSecretKey();
        } else {
            throw new RuntimeException("Unknown KeyUsage: " + (Object)((Object)keyUsage));
        }
        return stsKeyEntry;
    }

    public static class KeyRotationResult {
        private final List<String> removedKeys;
        private final List<String> generatedKeys;

        @ConstructorProperties(value={"removedKeys", "generatedKeys"})
        KeyRotationResult(List<String> removedKeys, List<String> generatedKeys) {
            this.removedKeys = removedKeys;
            this.generatedKeys = generatedKeys;
        }

        public static KeyRotationResultBuilder builder() {
            return new KeyRotationResultBuilder();
        }

        public List<String> getRemovedKeys() {
            return this.removedKeys;
        }

        public List<String> getGeneratedKeys() {
            return this.generatedKeys;
        }

        public static class KeyRotationResultBuilder {
            private List<String> removedKeys;
            private List<String> generatedKeys;

            KeyRotationResultBuilder() {
            }

            public KeyRotationResultBuilder removedKeys(List<String> removedKeys) {
                this.removedKeys = removedKeys;
                return this;
            }

            public KeyRotationResultBuilder generatedKeys(List<String> generatedKeys) {
                this.generatedKeys = generatedKeys;
                return this;
            }

            public KeyRotationResult build() {
                return new KeyRotationResult(this.removedKeys, this.generatedKeys);
            }

            public String toString() {
                return "KeyRotationService.KeyRotationResult.KeyRotationResultBuilder(removedKeys=" + this.removedKeys + ", generatedKeys=" + this.generatedKeys + ")";
            }
        }
    }
}

