/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import java.security.KeyPair;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.jjwk.serverkey.SingleKeyUsageSelfSignedCertBuilder;
import org.adorsys.jkeygen.keypair.KeyPairBuilder;
import org.adorsys.jkeygen.keypair.SelfSignedKeyPairData;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeyPairEntry;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairGenerator {
    private static final int[] keyUsageSignature = new int[]{64};
    private static final int[] keyUsageEncryption = new int[]{32, 16, 8};
    private final String keyAlgo;
    private final Integer keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;

    public KeyPairGenerator(KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties keyProperties) {
        this.keyAlgo = keyProperties.getAlgo();
        this.keySize = keyProperties.getSize();
        this.serverSigAlgo = keyProperties.getSigAlgo();
        this.serverKeyPairName = keyProperties.getName();
    }

    public KeyPairEntry generateSignatureKey(String alias, CallbackHandler keyPassHandler) {
        return this.generate(keyUsageSignature, alias, keyPassHandler);
    }

    public KeyPairEntry generateEncryptionKey(String alias, CallbackHandler keyPassHandler) {
        return this.generate(keyUsageEncryption, alias, keyPassHandler);
    }

    private KeyPairEntry generate(int[] keyUsages, String alias, CallbackHandler keyPassHandler) {
        KeyPair keyPair = new KeyPairBuilder().withKeyAlg(this.keyAlgo).withKeyLength(this.keySize).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.serverKeyPairName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withSubjectDN(dn).withSignatureAlgo(this.serverSigAlgo).withNotAfterInDays(Integer.valueOf(900)).withCa(false).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().keyPairs(keyPairData).alias(alias).passwordSource(keyPassHandler).build();
    }
}

