/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import de.adorsys.sts.keymanagement.service.KeyStoreFilter;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.adorsys.jjwk.serverkey.KeyAndJwk;
import org.adorsys.jjwk.serverkey.ServerKeyMap;
import org.adorsys.jjwk.serverkey.ServerKeyMapProvider;
import org.adorsys.jjwk.serverkey.ServerKeysHolder;

public class KeyManagementService
implements ServerKeyMapProvider {
    private final KeyStoreRepository repository;
    private final KeyStoreGenerator keyStoreGenerator;
    private final KeyConversionService keyConversionService;
    private final KeyStoreFilter keyStoreFilter;
    private StsKeyStore keyStore;

    public KeyManagementService(KeyStoreRepository repository, KeyStoreGenerator keyStoreGenerator, KeyConversionService keyConversionService, KeyStoreFilter keyStoreFilter) {
        this.repository = repository;
        this.keyStoreGenerator = keyStoreGenerator;
        this.keyConversionService = keyConversionService;
        this.keyStoreFilter = keyStoreFilter;
    }

    @PostConstruct
    public void postConstruct() {
        if (this.repository.exists()) {
            this.keyStore = this.repository.load();
        } else {
            this.keyStore = this.keyStoreGenerator.generate();
            this.repository.save(this.keyStore);
        }
    }

    public ServerKeyMap getKeyMap() {
        throw new IllegalStateException("Method not supported");
    }

    public ServerKeysHolder getServerKeysHolder() {
        throw new IllegalStateException("Method not supported");
    }

    public KeyAndJwk randomSecretKey() {
        return this.getSecretKeys().randomSecretKey();
    }

    public KeyAndJwk randomSignKey() {
        return this.getPrivateKeys().randomSignKey();
    }

    public Key getKey(String keyId) {
        ServerKeysHolder exportedKeys = this.keyConversionService.export(this.keyStore.getKeyStore());
        ServerKeyMap serverKeyMap = new ServerKeyMap(exportedKeys.getPrivateKeySet());
        return serverKeyMap.getKey(keyId);
    }

    public JWKSet getPublicKeys() {
        ServerKeysHolder exportedKeys = this.keyConversionService.export(this.keyStore.getKeyStore());
        Map<String, StsKeyEntry> keyEntries = this.keyStore.getKeyEntries();
        List filteredKeyAliases = keyEntries.values().stream().filter(this::hasUsablePublicKey).map(StsKeyEntry::getAlias).collect(Collectors.toList());
        List filteredKeys = exportedKeys.getPublicKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
        return new JWKSet(filteredKeys);
    }

    private ServerKeyMap getPrivateKeys() {
        return new ServerKeyMap(this.getFilteredPrivateKeys(this::hasUsablePrivateKey));
    }

    private ServerKeyMap getSecretKeys() {
        return new ServerKeyMap(this.getFilteredPrivateKeys(this::isUsableSecretKey));
    }

    private JWKSet getFilteredPrivateKeys(Predicate<StsKeyEntry> predicate) {
        ServerKeysHolder exportedKeys = this.keyConversionService.export(this.keyStore.getKeyStore());
        Map<String, StsKeyEntry> keyEntries = this.keyStore.getKeyEntries();
        List filteredKeyAliases = keyEntries.values().stream().filter(predicate).map(StsKeyEntry::getAlias).collect(Collectors.toList());
        List filteredKeys = exportedKeys.getPrivateKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
        return new JWKSet(filteredKeys);
    }

    private boolean hasUsablePublicKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && this.keyStoreFilter.isValid(stsKeyEntry) || stsKeyEntry.getKeyUsage() == KeyUsage.Signature && (this.keyStoreFilter.isValid(stsKeyEntry) || this.keyStoreFilter.isLegacy(stsKeyEntry));
    }

    private boolean hasUsablePrivateKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Signature && this.keyStoreFilter.isValid(stsKeyEntry) || stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && (this.keyStoreFilter.isValid(stsKeyEntry) || this.keyStoreFilter.isLegacy(stsKeyEntry));
    }

    private boolean isUsableSecretKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.SecretKey && this.keyStoreFilter.isValid(stsKeyEntry);
    }
}

