/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.model;

import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import java.beans.ConstructorProperties;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Map;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyStoreService;

public class StsKeyStore {
    private final Map<String, StsKeyEntry> keyEntries;
    private final KeyStore keyStore;

    public void addKey(StsKeyEntry keyEntry) {
        try {
            KeyStoreService.addToKeyStore((KeyStore)this.keyStore, (KeyEntry)keyEntry.getKeyEntry());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        this.keyEntries.put(keyEntry.getAlias(), keyEntry);
    }

    public void removeKey(String keyAlias) {
        this.keyEntries.remove(keyAlias);
        try {
            this.keyStore.deleteEntry(keyAlias);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"keyEntries", "keyStore"})
    StsKeyStore(Map<String, StsKeyEntry> keyEntries, KeyStore keyStore) {
        this.keyEntries = keyEntries;
        this.keyStore = keyStore;
    }

    public static StsKeyStoreBuilder builder() {
        return new StsKeyStoreBuilder();
    }

    public Map<String, StsKeyEntry> getKeyEntries() {
        return this.keyEntries;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public static class StsKeyStoreBuilder {
        private Map<String, StsKeyEntry> keyEntries;
        private KeyStore keyStore;

        StsKeyStoreBuilder() {
        }

        public StsKeyStoreBuilder keyEntries(Map<String, StsKeyEntry> keyEntries) {
            this.keyEntries = keyEntries;
            return this;
        }

        public StsKeyStoreBuilder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public StsKeyStore build() {
            return new StsKeyStore(this.keyEntries, this.keyStore);
        }

        public String toString() {
            return "StsKeyStore.StsKeyStoreBuilder(keyEntries=" + this.keyEntries + ", keyStore=" + this.keyStore + ")";
        }
    }
}

