/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.persistence;

import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedKeyStoreRepository
implements KeyStoreRepository {
    private static final Logger log = LoggerFactory.getLogger(CachedKeyStoreRepository.class);
    private final KeyStoreRepository keyStoreRepository;
    private StsKeyStore cachedKeyStore;

    public CachedKeyStoreRepository(KeyStoreRepository keyStoreRepository) {
        this.keyStoreRepository = keyStoreRepository;
    }

    public StsKeyStore load() {
        log.debug("Calling load(). Cached key store last update: {}", this.cachedKeyStore != null ? this.cachedKeyStore.getLastUpdate() : null);
        if (this.cachedKeyStore == null) {
            log.debug("Cache is null, loading from repository");
            this.cachedKeyStore = this.keyStoreRepository.load();
        } else {
            ZonedDateTime cachedLastUpdate;
            ZonedDateTime lastUpdate = this.keyStoreRepository.lastUpdate();
            if (lastUpdate.isAfter(cachedLastUpdate = this.cachedKeyStore.getLastUpdate())) {
                log.debug("Repository was updated more recently than cache. Refreshing cache.");
                this.cachedKeyStore = this.keyStoreRepository.load();
            }
        }
        log.debug("Returning cached key store with last update: {}", this.cachedKeyStore != null ? this.cachedKeyStore.getLastUpdate() : null);
        return this.cachedKeyStore;
    }

    public boolean exists() {
        boolean exists = this.cachedKeyStore != null || this.keyStoreRepository.exists();
        log.debug("Checking if KeyStore exists. Result: {}", (Object)exists);
        return exists;
    }

    public void save(StsKeyStore keyStore) {
        log.debug("Saving keyStore to repository...");
        this.keyStoreRepository.save(keyStore);
        log.debug("Updating cache with newly saved keyStore");
        this.cachedKeyStore = keyStore;
    }

    public ZonedDateTime lastUpdate() {
        ZonedDateTime lastUpdate = this.keyStoreRepository.lastUpdate();
        log.debug("LastUpdate: {}", (Object)lastUpdate);
        return lastUpdate;
    }
}

