/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import com.nimbusds.jose.jwk.JWKSet;
import de.adorsys.sts.common.model.KeyAndJwk;
import de.adorsys.sts.common.util.ImmutableLists;
import de.adorsys.sts.keymanagement.model.KeyState;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.ServerKeysHolder;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.persistence.KeyStoreRepository;
import de.adorsys.sts.keymanagement.service.KeyConversionService;
import de.adorsys.sts.keymanagement.service.ServerKeyMapProvider;
import de.adorsys.sts.keymanagement.util.StsServerKeyMap;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KeyManagementService
implements ServerKeyMapProvider {
    private static final JWKSet EMPTY_JWK_SET = new JWKSet(ImmutableLists.emptyList());
    private static final ServerKeysHolder EMPTY_KEYS = new ServerKeysHolder(EMPTY_JWK_SET, EMPTY_JWK_SET);
    private final KeyStoreRepository repository;
    private final KeyConversionService keyConversionService;

    public KeyManagementService(KeyStoreRepository repository, KeyConversionService keyConversionService) {
        this.repository = repository;
        this.keyConversionService = keyConversionService;
    }

    public KeyAndJwk randomSecretKey() {
        return this.getSecretKeys().randomSecretKey();
    }

    public KeyAndJwk randomSignKey() {
        return this.getPrivateKeys().randomSignKey();
    }

    public Key getKey(String keyId) {
        StsServerKeyMap serverKeyMap = new StsServerKeyMap(this.loadKeys().getPrivateKeySet());
        return serverKeyMap.getKey(keyId);
    }

    private ServerKeysHolder loadKeys() {
        ServerKeysHolder exportedKeys = this.repository.exists() ? this.keyConversionService.export(this.repository.load()) : EMPTY_KEYS;
        return exportedKeys;
    }

    public JWKSet getPublicKeys() {
        if (this.repository.exists()) {
            StsKeyStore keyStore = this.repository.load();
            ServerKeysHolder exportedKeys = this.keyConversionService.export(keyStore);
            Map keyEntries = keyStore.getEntries();
            List filteredKeyAliases = keyEntries.values().stream().filter(this::hasUsablePublicKey).map(StsKeyEntry::getAlias).collect(Collectors.toList());
            List filteredKeys = exportedKeys.getPublicKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
            return new JWKSet(filteredKeys);
        }
        return EMPTY_JWK_SET;
    }

    private StsServerKeyMap getPrivateKeys() {
        return new StsServerKeyMap(this.getFilteredPrivateKeys(this::hasUsablePrivateKey));
    }

    private StsServerKeyMap getSecretKeys() {
        return new StsServerKeyMap(this.getFilteredPrivateKeys(this::isUsableSecretKey));
    }

    private JWKSet getFilteredPrivateKeys(Predicate<StsKeyEntry> predicate) {
        if (this.repository.exists()) {
            StsKeyStore keyStore = this.repository.load();
            ServerKeysHolder exportedKeys = this.keyConversionService.export(keyStore);
            Map keyEntries = keyStore.getEntries();
            List filteredKeyAliases = keyEntries.values().stream().filter(predicate).map(StsKeyEntry::getAlias).collect(Collectors.toList());
            List filteredKeys = exportedKeys.getPrivateKeySet().getKeys().stream().filter(k -> filteredKeyAliases.contains(k.getKeyID())).collect(Collectors.toList());
            return new JWKSet(filteredKeys);
        }
        return EMPTY_JWK_SET;
    }

    private boolean hasUsablePublicKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && stsKeyEntry.getState() == KeyState.VALID || stsKeyEntry.getKeyUsage() == KeyUsage.Signature && (stsKeyEntry.getState() == KeyState.VALID || stsKeyEntry.getState() == KeyState.LEGACY);
    }

    private boolean hasUsablePrivateKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.Signature && stsKeyEntry.getState() == KeyState.VALID || stsKeyEntry.getKeyUsage() == KeyUsage.Encryption && (stsKeyEntry.getState() == KeyState.VALID || stsKeyEntry.getState() == KeyState.LEGACY);
    }

    private boolean isUsableSecretKey(StsKeyEntry stsKeyEntry) {
        return stsKeyEntry.getKeyUsage() == KeyUsage.SecretKey && stsKeyEntry.getState() == KeyState.VALID;
    }
}

