/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.template.generated.Encrypting;
import de.adorsys.keymanagement.api.types.template.generated.Signing;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyPair;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import java.util.function.Supplier;

public class KeyPairGeneratorImpl
implements KeyPairGenerator {
    private final Juggler juggler;
    private final String keyAlgo;
    private final Integer keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;

    public KeyPairGeneratorImpl(Juggler juggler, KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties keyProperties) {
        this.juggler = juggler;
        this.keyAlgo = keyProperties.getAlgo();
        this.keySize = keyProperties.getSize();
        this.serverSigAlgo = keyProperties.getSigAlgo();
        this.serverKeyPairName = keyProperties.getName();
    }

    public ProvidedKeyPair generateSignatureKey(String alias, Supplier<char[]> keyPassword) {
        return this.juggler.generateKeys().signing(Signing.with().alias(alias).algo(this.keyAlgo).keySize(this.keySize).sigAlgo(this.serverSigAlgo).commonName(this.serverKeyPairName).password(keyPassword).build());
    }

    public ProvidedKeyPair generateEncryptionKey(String alias, Supplier<char[]> keyPassword) {
        return this.juggler.generateKeys().encrypting(Encrypting.with().alias(alias).algo(this.keyAlgo).keySize(this.keySize).sigAlgo(this.serverSigAlgo).commonName(this.serverKeyPairName).password(keyPassword).build());
    }
}

