/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.template.generated.Secret;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKey;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import java.util.function.Supplier;

public class SecretKeyGeneratorImpl
implements SecretKeyGenerator {
    private final Juggler juggler;
    private final String secretKeyAlgo;
    private final Integer keySize;

    public SecretKeyGeneratorImpl(Juggler juggler, String secretKeyAlgo, Integer keySize) {
        this.juggler = juggler;
        this.secretKeyAlgo = secretKeyAlgo;
        this.keySize = keySize;
    }

    public SecretKeyGeneratorImpl(Juggler juggler, KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties secretKeyProperties) {
        this.juggler = juggler;
        this.secretKeyAlgo = secretKeyProperties.getAlgo();
        this.keySize = secretKeyProperties.getSize();
    }

    public ProvidedKey generate(String alias, Supplier<char[]> keyPassword) {
        return this.juggler.generateKeys().secret(Secret.with().alias(alias).algo(this.secretKeyAlgo).keySize(this.keySize).password(keyPassword).build());
    }
}

