/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sts.keymanagement.service;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.KeySetTemplate;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKey;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKeyPair;
import de.adorsys.sts.keymanagement.model.GeneratedStsEntry;
import de.adorsys.sts.keymanagement.model.KeyState;
import de.adorsys.sts.keymanagement.model.KeyUsage;
import de.adorsys.sts.keymanagement.model.PasswordCallbackHandler;
import de.adorsys.sts.keymanagement.model.StsKeyEntry;
import de.adorsys.sts.keymanagement.model.StsKeyEntryImpl;
import de.adorsys.sts.keymanagement.model.StsKeyStore;
import de.adorsys.sts.keymanagement.service.KeyManagementProperties;
import de.adorsys.sts.keymanagement.service.KeyPairGenerator;
import de.adorsys.sts.keymanagement.service.KeyStoreGenerator;
import de.adorsys.sts.keymanagement.service.SecretKeyGenerator;
import de.adorsys.sts.keymanagement.util.DateTimeUtils;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class KeyStoreGeneratorImpl
implements KeyStoreGenerator {
    private final Clock clock;
    private final Juggler juggler;
    private final KeyPairGenerator encKeyPairGenerator;
    private final KeyPairGenerator signKeyPairGenerator;
    private final SecretKeyGenerator secretKeyGenerator;
    private final String keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final PasswordCallbackHandler keyPassHandler;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties encKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.KeyPairProperties signKeyPairsProperties;
    private final KeyManagementProperties.KeyStoreProperties.KeysProperties.SecretKeyProperties secretKeyProperties;

    public KeyStoreGeneratorImpl(Juggler juggler, Clock clock, KeyPairGenerator encKeyPairGenerator, KeyPairGenerator signKeyPairGenerator, SecretKeyGenerator secretKeyGenerator, KeyManagementProperties keyManagementProperties) {
        this.juggler = juggler;
        this.clock = clock;
        this.encKeyPairGenerator = encKeyPairGenerator;
        this.signKeyPairGenerator = signKeyPairGenerator;
        this.secretKeyGenerator = secretKeyGenerator;
        KeyManagementProperties.KeyStoreProperties keystoreProperties = keyManagementProperties.getKeystore();
        this.keyStoreType = keystoreProperties.getType();
        this.serverKeyPairAliasPrefix = keystoreProperties.getAliasPrefix();
        String password = keystoreProperties.getPassword();
        this.encKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getEncKeyPairs();
        this.signKeyPairsProperties = keyManagementProperties.getKeystore().getKeys().getSignKeyPairs();
        this.secretKeyProperties = keyManagementProperties.getKeystore().getKeys().getSecretKeys();
        this.keyPassHandler = new PasswordCallbackHandler(password.toCharArray());
    }

    public StsKeyStore generate() {
        int i;
        KeySetTemplate.KeySetTemplateBuilder builder = KeySetTemplate.builder();
        for (i = 0; i < this.signKeyPairsProperties.getInitialCount(); ++i) {
            GeneratedStsEntry<ProvidedKeyPair> signKeyPair = this.generateSignatureKeyEntryForInstantUsage();
            builder = builder.providedPair((ProvidedKeyPair)signKeyPair.getKey());
            signKeyPair = this.generateSignatureKeyEntryForFutureUsage(signKeyPair.getEntry().getNotAfter());
            builder = builder.providedPair((ProvidedKeyPair)signKeyPair.getKey());
        }
        for (i = 0; i < this.encKeyPairsProperties.getInitialCount(); ++i) {
            GeneratedStsEntry<ProvidedKeyPair> encPair = this.generateEncryptionKeyEntryForInstantUsage();
            builder = builder.providedPair((ProvidedKeyPair)encPair.getKey());
            encPair = this.generateEncryptionKeyEntryForFutureUsage(encPair.getEntry().getNotAfter());
            builder = builder.providedPair((ProvidedKeyPair)encPair.getKey());
        }
        for (i = 0; i < this.secretKeyProperties.getInitialCount(); ++i) {
            GeneratedStsEntry<ProvidedKey> secretKey = this.generateSecretKeyEntryForInstantUsage();
            builder = builder.providedKey((ProvidedKey)secretKey.getKey());
            secretKey = this.generateSecretKeyEntryForFutureUsage(secretKey.getEntry().getNotAfter());
            builder = builder.providedKey((ProvidedKey)secretKey.getKey());
        }
        KeyStore keyStore = this.juggler.toKeystore().generate(this.juggler.generateKeys().fromTemplate(builder.build()), () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
        return StsKeyStore.builder().keyStore(keyStore).view(this.juggler.readKeys().fromKeyStore(keyStore, id -> this.keyPassHandler.getPassword()).entries()).lastUpdate(this.now()).build();
    }

    public GeneratedStsEntry generateKeyEntryForFutureUsage(KeyUsage keyUsage, ZonedDateTime notBefore) {
        GeneratedStsEntry<ProvidedKeyPair> generatedKeyEntry;
        if (keyUsage == KeyUsage.Encryption) {
            generatedKeyEntry = this.generateEncryptionKeyEntryForFutureUsage(notBefore);
        } else if (keyUsage == KeyUsage.Signature) {
            generatedKeyEntry = this.generateSignatureKeyEntryForFutureUsage(notBefore);
        } else if (keyUsage == KeyUsage.SecretKey) {
            generatedKeyEntry = this.generateSecretKeyEntryForFutureUsage(notBefore);
        } else {
            throw new IllegalArgumentException("unknown KeyUsage: " + keyUsage.name());
        }
        return generatedKeyEntry;
    }

    public GeneratedStsEntry<ProvidedKeyPair> generateSignatureKeyEntryForInstantUsage() {
        ProvidedKeyPair signatureKeyPair = this.generateSignKeyPair();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(signatureKeyPair.generateName()).createdAt(now).notBefore(now).validityInterval(this.signKeyPairsProperties.getValidityInterval()).legacyInterval(this.signKeyPairsProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.signKeyPairsProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.signKeyPairsProperties.getLegacyInterval())).keyUsage(KeyUsage.Signature).state(KeyState.VALID).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)signatureKeyPair.toBuilder().metadata((KeyMetadata)entry).build());
    }

    public GeneratedStsEntry<ProvidedKeyPair> generateSignatureKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        ProvidedKeyPair signatureKeyPair = this.generateSignKeyPair();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(signatureKeyPair.generateName()).createdAt(now).notBefore(notBefore).validityInterval(this.signKeyPairsProperties.getValidityInterval()).legacyInterval(this.signKeyPairsProperties.getLegacyInterval()).keyUsage(KeyUsage.Signature).state(KeyState.CREATED).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)signatureKeyPair.toBuilder().metadata((KeyMetadata)entry).build());
    }

    private ProvidedKeyPair generateSignKeyPair() {
        String alias = this.serverKeyPairAliasPrefix + UUID.randomUUID().toString();
        return this.signKeyPairGenerator.generateSignatureKey(alias, () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
    }

    public GeneratedStsEntry<ProvidedKeyPair> generateEncryptionKeyEntryForInstantUsage() {
        ProvidedKeyPair encryptionKeyPair = this.generateEncryptionKeyPair();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(encryptionKeyPair.generateName()).createdAt(now).notBefore(now).validityInterval(this.encKeyPairsProperties.getValidityInterval()).legacyInterval(this.encKeyPairsProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.encKeyPairsProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.encKeyPairsProperties.getLegacyInterval())).keyUsage(KeyUsage.Encryption).state(KeyState.VALID).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)encryptionKeyPair.toBuilder().metadata((KeyMetadata)entry).build());
    }

    public GeneratedStsEntry<ProvidedKeyPair> generateEncryptionKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        ProvidedKeyPair encryptionKeyPair = this.generateEncryptionKeyPair();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(encryptionKeyPair.generateName()).createdAt(now).notBefore(notBefore).validityInterval(this.encKeyPairsProperties.getValidityInterval()).legacyInterval(this.encKeyPairsProperties.getLegacyInterval()).keyUsage(KeyUsage.Encryption).state(KeyState.CREATED).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)encryptionKeyPair.toBuilder().metadata((KeyMetadata)entry).build());
    }

    private ProvidedKeyPair generateEncryptionKeyPair() {
        return this.encKeyPairGenerator.generateEncryptionKey(this.getSecureRandomAlias(), () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
    }

    public GeneratedStsEntry<ProvidedKey> generateSecretKeyEntryForInstantUsage() {
        ProvidedKey secretKeyData = this.generateSecretKey();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(secretKeyData.generateName()).createdAt(now).notBefore(now).validityInterval(this.secretKeyProperties.getValidityInterval()).legacyInterval(this.secretKeyProperties.getLegacyInterval()).notAfter(DateTimeUtils.addMillis(now, this.secretKeyProperties.getValidityInterval())).expireAt(DateTimeUtils.addMillis(now, this.secretKeyProperties.getLegacyInterval())).keyUsage(KeyUsage.SecretKey).state(KeyState.VALID).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)secretKeyData.toBuilder().metadata((KeyMetadata)entry).build());
    }

    public GeneratedStsEntry<ProvidedKey> generateSecretKeyEntryForFutureUsage(ZonedDateTime notBefore) {
        ProvidedKey secretKeyData = this.generateSecretKey();
        ZonedDateTime now = this.now();
        StsKeyEntryImpl entry = StsKeyEntryImpl.builder().alias(secretKeyData.generateName()).createdAt(now).notBefore(notBefore).validityInterval(this.secretKeyProperties.getValidityInterval()).legacyInterval(this.secretKeyProperties.getLegacyInterval()).keyUsage(KeyUsage.SecretKey).state(KeyState.CREATED).build();
        return new GeneratedStsEntry((StsKeyEntry)entry, (ProvidedKeyTemplate)secretKeyData.toBuilder().metadata((KeyMetadata)entry).build());
    }

    private ProvidedKey generateSecretKey() {
        return this.secretKeyGenerator.generate(this.getSecureRandomAlias(), () -> ((PasswordCallbackHandler)this.keyPassHandler).getPassword());
    }

    private String getSecureRandomAlias() {
        SecureRandom secureRandomInstance = new SecureRandom();
        String random = RandomStringUtils.random((int)5, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)secureRandomInstance);
        return this.serverKeyPairAliasPrefix + random.toUpperCase();
    }

    private ZonedDateTime now() {
        return this.clock.instant().atZone(ZoneOffset.UTC);
    }
}

